/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import com.arangodb.internal.serde.UserDataInside;
import com.arangodb.model.AqlQueryOptions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public final class ExplainAqlQueryOptions {
    private Map<String, Object> bindVars;
    private String query;
    private AqlQueryOptions.Options options;

    @UserDataInside
    public Map<String, Object> getBindVars() {
        return this.bindVars;
    }

    ExplainAqlQueryOptions bindVars(Map<String, Object> bindVars) {
        this.bindVars = bindVars;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    ExplainAqlQueryOptions query(String query) {
        this.query = query;
        return this;
    }

    public AqlQueryOptions.Options getOptions() {
        if (this.options == null) {
            this.options = new AqlQueryOptions.Options();
        }
        return this.options;
    }

    public ExplainAqlQueryOptions options(AqlQueryOptions.Options options) {
        this.options = options;
        return this;
    }

    @JsonIgnore
    public Map<String, Object> getCustomOptions() {
        return this.getOptions().getCustomOptions();
    }

    public ExplainAqlQueryOptions customOption(String key, Object value) {
        this.getOptions().setCustomOption(key, value);
        return this;
    }

    @JsonIgnore
    public Boolean getAllPlans() {
        return this.getOptions().getAllPlans();
    }

    public ExplainAqlQueryOptions allPlans(Boolean value) {
        this.getOptions().setAllPlans(value);
        return this;
    }

    @JsonIgnore
    public Boolean getAllowDirtyReads() {
        return this.getOptions().getAllowDirtyReads();
    }

    public ExplainAqlQueryOptions allowDirtyReads(Boolean allowDirtyReads) {
        this.getOptions().setAllowDirtyReads(allowDirtyReads);
        return this;
    }

    @JsonIgnore
    public Boolean getAllowRetry() {
        return this.getOptions().getAllowRetry();
    }

    public ExplainAqlQueryOptions allowRetry(Boolean allowRetry) {
        this.getOptions().setAllowRetry(allowRetry);
        return this;
    }

    @JsonIgnore
    public Boolean getFailOnWarning() {
        return this.getOptions().getFailOnWarning();
    }

    public ExplainAqlQueryOptions failOnWarning(Boolean failOnWarning) {
        this.getOptions().setFailOnWarning(failOnWarning);
        return this;
    }

    @JsonIgnore
    public Boolean getFillBlockCache() {
        return this.getOptions().getFillBlockCache();
    }

    public ExplainAqlQueryOptions fillBlockCache(Boolean fillBlockCache) {
        this.getOptions().setFillBlockCache(fillBlockCache);
        return this;
    }

    @JsonIgnore
    public String getForceOneShardAttributeValue() {
        return this.getOptions().getForceOneShardAttributeValue();
    }

    public ExplainAqlQueryOptions forceOneShardAttributeValue(String forceOneShardAttributeValue) {
        this.getOptions().setForceOneShardAttributeValue(forceOneShardAttributeValue);
        return this;
    }

    @JsonIgnore
    public Boolean getFullCount() {
        return this.getOptions().getFullCount();
    }

    public ExplainAqlQueryOptions fullCount(Boolean fullCount) {
        this.getOptions().setFullCount(fullCount);
        return this;
    }

    @JsonIgnore
    public Long getIntermediateCommitCount() {
        return this.getOptions().getIntermediateCommitCount();
    }

    public ExplainAqlQueryOptions intermediateCommitCount(Long intermediateCommitCount) {
        this.getOptions().setIntermediateCommitCount(intermediateCommitCount);
        return this;
    }

    @JsonIgnore
    public Long getIntermediateCommitSize() {
        return this.getOptions().getIntermediateCommitSize();
    }

    public ExplainAqlQueryOptions intermediateCommitSize(Long intermediateCommitSize) {
        this.getOptions().setIntermediateCommitSize(intermediateCommitSize);
        return this;
    }

    @JsonIgnore
    public Integer getMaxDNFConditionMembers() {
        return this.getOptions().getMaxDNFConditionMembers();
    }

    public ExplainAqlQueryOptions maxDNFConditionMembers(Integer maxDNFConditionMembers) {
        this.getOptions().setMaxDNFConditionMembers(maxDNFConditionMembers);
        return this;
    }

    @JsonIgnore
    public Integer getMaxNodesPerCallstack() {
        return this.getOptions().getMaxNodesPerCallstack();
    }

    public ExplainAqlQueryOptions maxNodesPerCallstack(Integer maxNodesPerCallstack) {
        this.getOptions().setMaxNodesPerCallstack(maxNodesPerCallstack);
        return this;
    }

    @JsonIgnore
    public Integer getMaxNumberOfPlans() {
        return this.getOptions().getMaxNumberOfPlans();
    }

    public ExplainAqlQueryOptions maxNumberOfPlans(Integer maxNumberOfPlans) {
        this.getOptions().setMaxNumberOfPlans(maxNumberOfPlans);
        return this;
    }

    @JsonIgnore
    public Double getMaxRuntime() {
        return this.getOptions().getMaxRuntime();
    }

    public ExplainAqlQueryOptions maxRuntime(Double maxRuntime) {
        this.getOptions().setMaxRuntime(maxRuntime);
        return this;
    }

    @JsonIgnore
    public Long getMaxTransactionSize() {
        return this.getOptions().getMaxTransactionSize();
    }

    public ExplainAqlQueryOptions maxTransactionSize(Long maxTransactionSize) {
        this.getOptions().setMaxTransactionSize(maxTransactionSize);
        return this;
    }

    @JsonIgnore
    public Long getMaxWarningCount() {
        return this.getOptions().getMaxWarningCount();
    }

    public ExplainAqlQueryOptions maxWarningCount(Long maxWarningCount) {
        this.getOptions().setMaxWarningCount(maxWarningCount);
        return this;
    }

    @JsonIgnore
    public AqlQueryOptions.Optimizer getOptimizer() {
        return this.getOptions().getOptimizer();
    }

    public ExplainAqlQueryOptions optimizer(AqlQueryOptions.Optimizer optimizer) {
        this.getOptions().setOptimizer(optimizer);
        return this;
    }

    @JsonIgnore
    public Boolean getProfile() {
        return this.getOptions().getProfile();
    }

    public ExplainAqlQueryOptions profile(Boolean profile) {
        this.getOptions().setProfile(profile);
        return this;
    }

    @JsonIgnore
    public Double getSatelliteSyncWait() {
        return this.getOptions().getSatelliteSyncWait();
    }

    public ExplainAqlQueryOptions satelliteSyncWait(Double satelliteSyncWait) {
        this.getOptions().setSatelliteSyncWait(satelliteSyncWait);
        return this;
    }

    @JsonIgnore
    public Collection<String> getShardIds() {
        return this.getOptions().getShardIds();
    }

    public ExplainAqlQueryOptions shardIds(String ... shardIds) {
        this.getOptions().setShardIds(Arrays.asList(shardIds));
        return this;
    }

    @JsonIgnore
    public Boolean getSkipInaccessibleCollections() {
        return this.getOptions().getSkipInaccessibleCollections();
    }

    public ExplainAqlQueryOptions skipInaccessibleCollections(Boolean skipInaccessibleCollections) {
        this.getOptions().setSkipInaccessibleCollections(skipInaccessibleCollections);
        return this;
    }

    @JsonIgnore
    public Long getSpillOverThresholdMemoryUsage() {
        return this.getOptions().getSpillOverThresholdMemoryUsage();
    }

    public ExplainAqlQueryOptions spillOverThresholdMemoryUsage(Long spillOverThresholdMemoryUsage) {
        this.getOptions().setSpillOverThresholdMemoryUsage(spillOverThresholdMemoryUsage);
        return this;
    }

    @JsonIgnore
    public Long getSpillOverThresholdNumRows() {
        return this.getOptions().getSpillOverThresholdNumRows();
    }

    public ExplainAqlQueryOptions spillOverThresholdNumRows(Long spillOverThresholdNumRows) {
        this.getOptions().setSpillOverThresholdNumRows(spillOverThresholdNumRows);
        return this;
    }

    @JsonIgnore
    public Boolean getStream() {
        return this.getOptions().getStream();
    }

    public ExplainAqlQueryOptions stream(Boolean stream) {
        this.getOptions().setStream(stream);
        return this;
    }

    @JsonIgnore
    public Collection<String> getRules() {
        return this.getOptions().getOptimizer().getRules();
    }

    public ExplainAqlQueryOptions rules(Collection<String> rules) {
        this.getOptions().getOptimizer().setRules(rules);
        return this;
    }
}

