/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.serde;

import com.arangodb.entity.CollectionStatus;
import com.arangodb.entity.CollectionType;
import com.arangodb.entity.InvertedIndexPrimarySort;
import com.arangodb.entity.ReplicationFactor;
import com.arangodb.entity.arangosearch.CollectionLink;
import com.arangodb.entity.arangosearch.FieldLink;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.serde.SerdeUtils;
import com.arangodb.util.RawBytes;
import com.arangodb.util.RawJson;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public final class InternalDeserializers {
    static final JsonDeserializer<RawJson> RAW_JSON_DESERIALIZER = new JsonDeserializer<RawJson>(){

        public RawJson deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if ("JSON".equals(p.getCodec().getFactory().getFormatName())) {
                return RawJson.of(new String(SerdeUtils.extractBytes(p), StandardCharsets.UTF_8));
            }
            StringWriter w = new StringWriter();
            try (JsonGenerator gen = SerdeUtils.INSTANCE.getJsonMapper().getFactory().createGenerator((Writer)w);){
                gen.copyCurrentStructure(p);
                gen.flush();
            }
            return RawJson.of(w.toString());
        }
    };
    static final JsonDeserializer<RawBytes> RAW_BYTES_DESERIALIZER = new JsonDeserializer<RawBytes>(){

        public RawBytes deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return RawBytes.of(SerdeUtils.extractBytes(p));
        }
    };
    static final JsonDeserializer<CollectionStatus> COLLECTION_STATUS = new JsonDeserializer<CollectionStatus>(){

        public CollectionStatus deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return CollectionStatus.fromStatus(p.getIntValue());
        }
    };
    static final JsonDeserializer<CollectionType> COLLECTION_TYPE = new JsonDeserializer<CollectionType>(){

        public CollectionType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return CollectionType.fromType(p.getIntValue());
        }
    };
    static final JsonDeserializer<ReplicationFactor> REPLICATION_FACTOR = new JsonDeserializer<ReplicationFactor>(){

        public ReplicationFactor deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            TreeNode node = p.readValueAsTree();
            if (node instanceof NumericNode) {
                return ReplicationFactor.of(((NumericNode)node).intValue());
            }
            if (node instanceof TextNode && "satellite".equals(((TextNode)node).textValue())) {
                return ReplicationFactor.ofSatellite();
            }
            throw new IllegalArgumentException();
        }
    };
    static final JsonDeserializer<InternalResponse> RESPONSE = new JsonDeserializer<InternalResponse>(){

        public InternalResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            InternalResponse response = new InternalResponse();
            Iterator it = ((ArrayNode)p.readValueAsTree()).iterator();
            response.setVersion(((JsonNode)it.next()).intValue());
            response.setType(((JsonNode)it.next()).intValue());
            response.setResponseCode(((JsonNode)it.next()).intValue());
            if (it.hasNext()) {
                response.putMetas((Map)InternalDeserializers.readTreeAsValue(p, ctxt, (JsonNode)it.next(), Map.class));
            }
            return response;
        }
    };
    static final JsonDeserializer<InvertedIndexPrimarySort.Field> INVERTED_INDEX_PRIMARY_SORT_FIELD = new JsonDeserializer<InvertedIndexPrimarySort.Field>(){

        public InvertedIndexPrimarySort.Field deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ObjectNode tree = (ObjectNode)p.readValueAsTree();
            String field = tree.get("field").textValue();
            InvertedIndexPrimarySort.Field.Direction direction = tree.get("asc").booleanValue() ? InvertedIndexPrimarySort.Field.Direction.asc : InvertedIndexPrimarySort.Field.Direction.desc;
            return new InvertedIndexPrimarySort.Field(field, direction);
        }
    };

    private InternalDeserializers() {
    }

    private static <T> T readTreeAsValue(JsonParser p, DeserializationContext ctxt, JsonNode n, Class<T> targetType) throws IOException {
        try (TreeTraversingParser t = new TreeTraversingParser(n, p.getCodec());){
            t.nextToken();
            Object object = ctxt.readValue((JsonParser)t, targetType);
            return (T)object;
        }
    }

    public static class CollectionSchemaRuleDeserializer
    extends JsonDeserializer<String> {
        public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return SerdeUtils.INSTANCE.writeJson((JsonNode)p.readValueAsTree());
        }
    }

    public static class FieldLinksDeserializer
    extends JsonDeserializer<FieldLink[]> {
        public FieldLink[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ArrayList<FieldLink> out = new ArrayList<FieldLink>();
            ObjectNode tree = (ObjectNode)p.readValueAsTree();
            Iterator it = tree.fields();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                ObjectNode v = (ObjectNode)e.getValue();
                v.put("name", (String)e.getKey());
                out.add((FieldLink)InternalDeserializers.readTreeAsValue(p, ctxt, (JsonNode)v, FieldLink.class));
            }
            return out.toArray(new FieldLink[0]);
        }
    }

    public static class CollectionLinksDeserializer
    extends JsonDeserializer<Collection<CollectionLink>> {
        public Collection<CollectionLink> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ArrayList<CollectionLink> out = new ArrayList<CollectionLink>();
            ObjectNode tree = (ObjectNode)p.readValueAsTree();
            Iterator it = tree.fields();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                ObjectNode v = (ObjectNode)e.getValue();
                v.put("name", (String)e.getKey());
                out.add((CollectionLink)InternalDeserializers.readTreeAsValue(p, ctxt, (JsonNode)v, CollectionLink.class));
            }
            return out;
        }
    }
}

