/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDBMultipleException;
import com.arangodb.config.HostDescription;
import com.arangodb.internal.net.AccessType;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.HostSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class FallbackHostHandler
implements HostHandler {
    private final HostResolver resolver;
    private final List<Throwable> lastFailExceptions;
    private Host current;
    private Host lastSuccess;
    private int iterations;
    private HostSet hosts;

    public FallbackHostHandler(HostResolver resolver) {
        this.resolver = resolver;
        this.lastFailExceptions = new CopyOnWriteArrayList<Throwable>();
        this.reset();
        this.hosts = resolver.getHosts();
        this.current = this.lastSuccess = this.hosts.getHostsList().get(0);
    }

    @Override
    public Host get(HostHandle hostHandle, AccessType accessType) {
        this.checkNext(hostHandle, accessType);
        if (this.current.isMarkforDeletion()) {
            this.fail(new ArangoDBException("Host marked for deletion"));
        }
        return this.current;
    }

    @Override
    public void checkNext(HostHandle hostHandle, AccessType accessType) {
        if (this.current == this.lastSuccess && this.iterations >= 3) {
            ArangoDBException e = ArangoDBException.of("Cannot contact any host!", new ArangoDBMultipleException(new ArrayList<Throwable>(this.lastFailExceptions)));
            this.reset();
            throw e;
        }
    }

    @Override
    public void success() {
        this.lastSuccess = this.current;
        this.reset();
    }

    @Override
    public void fail(Exception exception) {
        this.hosts = this.resolver.getHosts();
        List<Host> hostList = this.hosts.getHostsList();
        int index = hostList.indexOf(this.current) + 1;
        boolean inBound = index < hostList.size();
        this.current = hostList.get(inBound ? index : 0);
        if (!inBound) {
            ++this.iterations;
        }
        this.lastFailExceptions.add(exception);
    }

    @Override
    public synchronized void failIfNotMatch(HostDescription host, Exception exception) {
        if (!host.equals(this.current.getDescription())) {
            this.fail(exception);
        }
    }

    @Override
    public void reset() {
        this.iterations = 0;
        this.lastFailExceptions.clear();
    }

    @Override
    public void close() {
        this.hosts.close();
        this.resolver.close();
    }

    @Override
    public void setJwt(String jwt) {
        this.hosts.setJwt(jwt);
    }
}

