/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadedProxy {
    private static final Logger LOG = LoggerFactory.getLogger(ShadedProxy.class);
    private static final ClassLoader classLoader = ShadedProxy.class.getClassLoader();

    public static <T> T of(Class<T> i, Object target) {
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{i}, (InvocationHandler)new ShadedInvocationHandler(i, target));
    }

    public static Optional<Object> getTarget(Object o) {
        InvocationHandler h;
        if (Proxy.isProxyClass(o.getClass()) && (h = Proxy.getInvocationHandler(o)) instanceof ShadedInvocationHandler) {
            return Optional.of(((ShadedInvocationHandler)h).target);
        }
        return Optional.empty();
    }

    private static class ShadedInvocationHandler
    implements InvocationHandler {
        private final Map<ProxyMethod, Method> targetMethods = new HashMap<ProxyMethod, Method>();
        private final Map<ProxyMethod, Class<?>> proxiedReturnTypes = new HashMap();
        private final Object target;

        ShadedInvocationHandler(Class<?> i, Object target) {
            this.target = target;
            HashMap<ProxyMethod, Method> iMethods = new HashMap<ProxyMethod, Method>();
            for (Method method : i.getDeclaredMethods()) {
                iMethods.put(new ProxyMethod(method), method);
            }
            Method[] methods = target instanceof Class ? ((Class)target).getMethods() : target.getClass().getMethods();
            for (Method method : methods) {
                ProxyMethod pm = new ProxyMethod(method);
                Method iMethod = (Method)iMethods.get(pm);
                if (iMethod == null) continue;
                LOG.trace("adding {}", (Object)iMethod);
                this.targetMethods.put(pm, method);
                Class<?> mRet = method.getReturnType();
                Class<?> iRet = iMethod.getReturnType();
                if (mRet.equals(iRet)) continue;
                LOG.trace("adding proxied return type {}", iRet);
                this.proxiedReturnTypes.put(pm, iRet);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            Object[] realArgs;
            ProxyMethod pm = new ProxyMethod(method);
            Method targetMethod = this.targetMethods.get(pm);
            LOG.trace("Proxying invocation \n\t of: {} \n\t to: {}", (Object)method, (Object)targetMethod);
            Class<?> returnProxy = this.proxiedReturnTypes.get(pm);
            if (args == null) {
                realArgs = null;
            } else {
                realArgs = new Object[args.length];
                for (int i = 0; i < args.length; ++i) {
                    realArgs[i] = ShadedProxy.getTarget(args[i]).orElse(args[i]);
                }
            }
            Object res = targetMethod.invoke(this.target, realArgs);
            if (returnProxy != null) {
                LOG.trace("proxying return type \n\t of: {} \n\t to: {}", targetMethod.getReturnType(), returnProxy);
                return ShadedProxy.of(returnProxy, res);
            }
            return res;
        }

        private static class ProxyMethod {
            private final String name;
            private final String simpleReturnType;
            private final String[] simpleParameterTypes;

            public ProxyMethod(Method method) {
                this.name = method.getName();
                this.simpleReturnType = method.getReturnType().getSimpleName();
                this.simpleParameterTypes = new String[method.getParameterTypes().length];
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    this.simpleParameterTypes[i] = method.getParameterTypes()[i].getSimpleName();
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ProxyMethod that = (ProxyMethod)o;
                return Objects.equals(this.name, that.name) && Objects.equals(this.simpleReturnType, that.simpleReturnType) && Arrays.equals(this.simpleParameterTypes, that.simpleParameterTypes);
            }

            public int hashCode() {
                int result = Objects.hash(this.name, this.simpleReturnType);
                result = 31 * result + Arrays.hashCode(this.simpleParameterTypes);
                return result;
            }
        }
    }
}

