/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabaseAsync;
import com.arangodb.ArangoViewAsync;
import com.arangodb.entity.ViewEntity;
import com.arangodb.internal.ArangoDatabaseAsyncImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.InternalArangoView;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class ArangoViewAsyncImpl
extends InternalArangoView
implements ArangoViewAsync {
    private final ArangoDatabaseAsyncImpl db;

    protected ArangoViewAsyncImpl(ArangoDatabaseAsyncImpl db, String name) {
        super(db, db.name(), name);
        this.db = db;
    }

    @Override
    public ArangoDatabaseAsync db() {
        return this.db;
    }

    @Override
    public CompletableFuture<Boolean> exists() {
        return ((CompletableFuture)this.getInfo().thenApply(Objects::nonNull)).exceptionally(err -> {
            ArangoDBException aEx;
            Throwable e;
            Throwable throwable = e = err instanceof CompletionException ? err.getCause() : err;
            if (e instanceof ArangoDBException && ArangoErrors.matches(aEx = (ArangoDBException)e, 404, ArangoErrors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND)) {
                return false;
            }
            throw ArangoDBException.of(e);
        });
    }

    @Override
    public CompletableFuture<Void> drop() {
        return this.executorAsync().execute(this::dropRequest, (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<ViewEntity> rename(String newName) {
        return this.executorAsync().execute(() -> this.renameRequest(newName), (Type)((Object)ViewEntity.class));
    }

    @Override
    public CompletableFuture<ViewEntity> getInfo() {
        return this.executorAsync().execute(this::getInfoRequest, (Type)((Object)ViewEntity.class));
    }
}

