/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.ArangoDBAsync;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoMetrics;
import com.arangodb.ArangoSerdeAccessor;
import com.arangodb.Compression;
import com.arangodb.Protocol;
import com.arangodb.Request;
import com.arangodb.Response;
import com.arangodb.arch.UnstableApi;
import com.arangodb.config.ArangoConfigProperties;
import com.arangodb.config.HostDescription;
import com.arangodb.config.ProtocolConfig;
import com.arangodb.entity.ArangoDBEngine;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.LoadBalancingStrategy;
import com.arangodb.entity.LogEntriesEntity;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryOptimizerRule;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.CommunicationProtocol;
import com.arangodb.internal.net.ConnectionFactory;
import com.arangodb.internal.net.DirtyReadHostHandler;
import com.arangodb.internal.net.ExtendedHostResolver;
import com.arangodb.internal.net.FallbackHostHandler;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.ProtocolProvider;
import com.arangodb.internal.net.RandomHostHandler;
import com.arangodb.internal.net.RoundRobinHostHandler;
import com.arangodb.internal.net.SimpleHostResolver;
import com.arangodb.internal.util.HostUtils;
import com.arangodb.model.DBCreateOptions;
import com.arangodb.model.LogLevelOptions;
import com.arangodb.model.LogOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import com.arangodb.serde.ArangoSerde;
import com.arangodb.serde.ArangoSerdeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public interface ArangoDB
extends ArangoSerdeAccessor {
    public ArangoDBAsync async();

    public void shutdown();

    public void updateJwt(String var1);

    public ArangoDatabase db();

    public ArangoDatabase db(String var1);

    public ArangoMetrics metrics();

    public Boolean createDatabase(String var1);

    public Boolean createDatabase(DBCreateOptions var1);

    public Collection<String> getDatabases();

    public Collection<String> getAccessibleDatabases();

    public Collection<String> getAccessibleDatabasesFor(String var1);

    public ArangoDBVersion getVersion();

    public ArangoDBEngine getEngine();

    public ServerRole getRole();

    public String getServerId();

    public UserEntity createUser(String var1, String var2);

    public UserEntity createUser(String var1, String var2, UserCreateOptions var3);

    public void deleteUser(String var1);

    public UserEntity getUser(String var1);

    public Collection<UserEntity> getUsers();

    public UserEntity updateUser(String var1, UserUpdateOptions var2);

    public UserEntity replaceUser(String var1, UserUpdateOptions var2);

    public void grantDefaultDatabaseAccess(String var1, Permissions var2);

    public void grantDefaultCollectionAccess(String var1, Permissions var2);

    public <T> Response<T> execute(Request<?> var1, Class<T> var2);

    public LogEntriesEntity getLogEntries(LogOptions var1);

    public LogLevelEntity getLogLevel();

    public LogLevelEntity getLogLevel(LogLevelOptions var1);

    public LogLevelEntity setLogLevel(LogLevelEntity var1);

    public LogLevelEntity setLogLevel(LogLevelEntity var1, LogLevelOptions var2);

    public LogLevelEntity resetLogLevels(LogLevelOptions var1);

    public Collection<QueryOptimizerRule> getQueryOptimizerRules();

    public static class Builder {
        private static final Logger LOG = LoggerFactory.getLogger(Builder.class);
        private final ArangoConfig config = new ArangoConfig();

        public ArangoDB build() {
            if (this.config.getHosts().isEmpty()) {
                throw new ArangoDBException("No host has been set!");
            }
            ProtocolProvider protocolProvider = this.protocolProvider(this.config.getProtocol());
            this.config.setProtocolModule(protocolProvider.protocolModule());
            ConnectionFactory connectionFactory = protocolProvider.createConnectionFactory(this.config.getProtocolConfig());
            Collection<Host> hostList = this.createHostList(connectionFactory);
            HostResolver hostResolver = this.createHostResolver(hostList, connectionFactory);
            HostHandler hostHandler = this.createHostHandler(hostResolver);
            hostHandler.setJwt(this.config.getJwt());
            CommunicationProtocol protocol = protocolProvider.createProtocol(this.config, hostHandler);
            ArangoExecutorSync executor = new ArangoExecutorSync(protocol, this.config);
            hostResolver.init(executor, this.config.getInternalSerde());
            return new ArangoDBImpl(this.config, protocol, hostHandler);
        }

        public Builder loadProperties(ArangoConfigProperties properties) {
            this.config.loadProperties(properties);
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.config.setProtocol(protocol);
            return this;
        }

        public Builder host(String host, int port) {
            this.config.addHost(new HostDescription(host, port));
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.config.setTimeout(timeout);
            return this;
        }

        public Builder user(String user) {
            this.config.setUser(user);
            return this;
        }

        public Builder password(String password) {
            this.config.setPassword(password);
            return this;
        }

        public Builder jwt(String jwt) {
            this.config.setJwt(jwt);
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.config.setUseSsl(useSsl);
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.config.setSslContext(sslContext);
            return this;
        }

        public Builder verifyHost(Boolean verifyHost) {
            this.config.setVerifyHost(verifyHost);
            return this;
        }

        public Builder chunkSize(Integer chunkSize) {
            this.config.setChunkSize(chunkSize);
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.config.setMaxConnections(maxConnections);
            return this;
        }

        public Builder connectionTtl(Long connectionTtl) {
            this.config.setConnectionTtl(connectionTtl);
            return this;
        }

        public Builder keepAliveInterval(Integer keepAliveInterval) {
            this.config.setKeepAliveInterval(keepAliveInterval);
            return this;
        }

        public Builder acquireHostList(Boolean acquireHostList) {
            this.config.setAcquireHostList(acquireHostList);
            return this;
        }

        public Builder acquireHostListInterval(Integer acquireHostListInterval) {
            this.config.setAcquireHostListInterval(acquireHostListInterval);
            return this;
        }

        public Builder loadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
            this.config.setLoadBalancingStrategy(loadBalancingStrategy);
            return this;
        }

        public Builder responseQueueTimeSamples(Integer responseQueueTimeSamples) {
            this.config.setResponseQueueTimeSamples(responseQueueTimeSamples);
            return this;
        }

        public Builder serde(ArangoSerde serde) {
            this.config.setUserDataSerde(serde);
            return this;
        }

        public Builder serdeProviderClass(Class<? extends ArangoSerdeProvider> serdeProviderClass) {
            this.config.setUserDataSerdeProvider(serdeProviderClass);
            return this;
        }

        @Deprecated
        public Builder asyncExecutor(Executor executor) {
            this.config.setAsyncExecutor(executor);
            return this;
        }

        public Builder compression(Compression compression) {
            this.config.setCompression(compression);
            return this;
        }

        public Builder compressionThreshold(Integer threshold) {
            this.config.setCompressionThreshold(threshold);
            return this;
        }

        public Builder compressionLevel(Integer level) {
            this.config.setCompressionLevel(level);
            return this;
        }

        public Builder protocolConfig(ProtocolConfig protocolConfig) {
            this.config.setProtocolConfig(protocolConfig);
            return this;
        }

        @UnstableApi
        protected ProtocolProvider protocolProvider(Protocol protocol) {
            ServiceLoader<ProtocolProvider> loader = ServiceLoader.load(ProtocolProvider.class);
            Iterator<ProtocolProvider> iterator = loader.iterator();
            while (iterator.hasNext()) {
                ProtocolProvider p;
                try {
                    p = iterator.next();
                }
                catch (ServiceConfigurationError e) {
                    LOG.warn("ServiceLoader failed to load ProtocolProvider", (Throwable)e);
                    continue;
                }
                if (p.supportsProtocol(protocol)) {
                    return p;
                }
                LOG.debug("Required protocol ({}) not supported by ProtocolProvider: {}", (Object)protocol, (Object)p.getClass().getName());
            }
            throw new ArangoDBException("No ProtocolProvider found for protocol: " + (Object)((Object)protocol));
        }

        @UnstableApi
        protected HostHandler createHostHandler(@UnstableApi HostResolver hostResolver) {
            HostHandler hostHandler;
            LoadBalancingStrategy loadBalancingStrategy = this.config.getLoadBalancingStrategy();
            if (loadBalancingStrategy != null) {
                switch (loadBalancingStrategy) {
                    case ONE_RANDOM: {
                        hostHandler = new RandomHostHandler(hostResolver, new FallbackHostHandler(hostResolver));
                        break;
                    }
                    case ROUND_ROBIN: {
                        hostHandler = new RoundRobinHostHandler(hostResolver);
                        break;
                    }
                    default: {
                        hostHandler = new FallbackHostHandler(hostResolver);
                        break;
                    }
                }
            } else {
                hostHandler = new FallbackHostHandler(hostResolver);
            }
            LOG.debug("HostHandler is {}", (Object)hostHandler.getClass().getSimpleName());
            return new DirtyReadHostHandler(hostHandler, new RoundRobinHostHandler(hostResolver));
        }

        @UnstableApi
        protected HostResolver createHostResolver(@UnstableApi Collection<Host> hosts, @UnstableApi ConnectionFactory connectionFactory) {
            Boolean acquireHostList = this.config.getAcquireHostList();
            if (acquireHostList != null && acquireHostList.booleanValue()) {
                LOG.debug("acquireHostList -> Use ExtendedHostResolver");
                return new ExtendedHostResolver(new ArrayList<Host>(hosts), this.config, connectionFactory, this.config.getAcquireHostListInterval());
            }
            LOG.debug("Use SimpleHostResolver");
            return new SimpleHostResolver(new ArrayList<Host>(hosts));
        }

        @UnstableApi
        protected Collection<Host> createHostList(@UnstableApi ConnectionFactory connectionFactory) {
            ArrayList<Host> hostList = new ArrayList<Host>();
            for (HostDescription host : this.config.getHosts()) {
                hostList.add(HostUtils.createHost(host, this.config, connectionFactory));
            }
            return hostList;
        }
    }
}

