/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.repository.query.derived;

public class Criteria {
    private static final String AND_DELIMITER = " AND ";
    private static final String OR_DELIMITER = " OR ";
    private final StringBuilder predicate;

    public Criteria() {
        this("");
    }

    public Criteria(String predicate) {
        this.predicate = new StringBuilder(predicate);
    }

    public String getPredicate() {
        return this.predicate.toString();
    }

    public Criteria and(Criteria criteria) {
        return this.add(AND_DELIMITER, criteria);
    }

    public Criteria or(Criteria criteria) {
        return this.add(OR_DELIMITER, criteria);
    }

    private Criteria add(String delimiter, Criteria criteria) {
        if (criteria == null) {
            return this;
        }
        if (this.predicate.length() > 0) {
            this.predicate.append(delimiter);
        }
        this.predicate.append((CharSequence)criteria.predicate);
        return this;
    }

    public static Criteria eql(String property, int index) {
        return new Criteria(property + " == @" + index);
    }

    public static Criteria neql(String property, int index) {
        return new Criteria(property + " != @" + index);
    }

    public static Criteria isTrue(String property) {
        return new Criteria(property + " == true");
    }

    public static Criteria isFalse(String property) {
        return new Criteria(property + " == false");
    }

    public static Criteria isNull(String property) {
        return new Criteria(property + " == null");
    }

    public static Criteria isNotNull(String property) {
        return new Criteria(property + " != null");
    }

    public static Criteria exists(String document, String attribute) {
        return new Criteria("HAS(" + document + ", '" + attribute + "')");
    }

    public static Criteria lt(String property, int index) {
        return new Criteria(property + " < @" + index);
    }

    public static Criteria gt(String property, int index) {
        return new Criteria(property + " > @" + index);
    }

    public static Criteria lte(String property, int index) {
        return new Criteria(property + " <= @" + index);
    }

    public static Criteria lte(int index, String property) {
        return new Criteria("@" + index + " <= " + property);
    }

    public static Criteria gte(String property, int index) {
        return new Criteria(property + " >= @" + index);
    }

    public static Criteria like(String property, int index) {
        return new Criteria(property + " LIKE @" + index);
    }

    public static Criteria notLike(String property, int index) {
        return new Criteria("NOT(" + property + " LIKE @" + index + ")");
    }

    public static Criteria regex(String property, int index, boolean caseInsensitive) {
        return new Criteria("REGEX_TEST(" + property + ", @" + index + ", " + caseInsensitive + ")");
    }

    public static Criteria in(String property, int index) {
        return new Criteria(property + " IN @" + index);
    }

    public static Criteria in(int index, String property) {
        return new Criteria("@" + index + " IN " + property);
    }

    public static Criteria nin(String property, int index) {
        return new Criteria(property + " NOT IN @" + index);
    }

    public static Criteria nin(int index, String property) {
        return new Criteria("@" + index + " NOT IN " + property);
    }

    public static Criteria contains(String property, int index) {
        return new Criteria("CONTAINS(" + property + ", @" + index + ")");
    }

    public static Criteria distance(String property, int indexLat, int indexLong) {
        return new Criteria("DISTANCE(" + property + "[0], " + property + "[1], @" + indexLat + ", @" + indexLong + ")");
    }

    public static Criteria isInPolygon(int index, String property) {
        return new Criteria("IS_IN_POLYGON(@" + index + ", " + property + "[0], " + property + "[1])");
    }

    public String toString() {
        return this.predicate.toString();
    }
}

