/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.repository.query;

import com.arangodb.model.AqlQueryOptions;
import com.arangodb.springframework.core.ArangoOperations;
import com.arangodb.springframework.core.util.AqlUtils;
import com.arangodb.springframework.repository.query.AbstractArangoQuery;
import com.arangodb.springframework.repository.query.ArangoParameterAccessor;
import com.arangodb.springframework.repository.query.ArangoParameters;
import com.arangodb.springframework.repository.query.ArangoQueryMethod;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class StringBasedArangoQuery
extends AbstractArangoQuery {
    private static final String PAGEABLE_PLACEHOLDER = "#pageable";
    private static final Pattern PAGEABLE_PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote("#pageable"));
    private static final String SORT_PLACEHOLDER = "#sort";
    private static final Pattern SORT_PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote("#sort"));
    private static final String COLLECTION_PLACEHOLDER = "#collection";
    private static final Pattern COLLECTION_PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote("#collection"));
    private static final Pattern BIND_PARAM_PATTERN = Pattern.compile("@(@?[A-Za-z0-9][A-Za-z0-9_]*)");
    private final String query;
    private final Set<String> queryBindParams;

    public StringBasedArangoQuery(ArangoQueryMethod method, ArangoOperations operations) {
        this(method.getAnnotatedQuery(), method, operations);
    }

    public StringBasedArangoQuery(String query, ArangoQueryMethod method, ArangoOperations operations) {
        super(method, operations);
        Assert.notNull((Object)query, (String)"Query must not be null!");
        this.query = query;
        this.assertSinglePageablePlaceholder();
        this.assertSingleSortPlaceholder();
        this.queryBindParams = this.getBindParamsInQuery();
    }

    @Override
    protected String createQuery(ArangoParameterAccessor accessor, Map<String, Object> bindVars, AqlQueryOptions options) {
        this.extractBindVars(accessor, bindVars);
        return this.prepareQuery(accessor);
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    private String prepareQuery(ArangoParameterAccessor accessor) {
        String preparedQuery = this.query;
        Matcher collectionMatcher = COLLECTION_PLACEHOLDER_PATTERN.matcher(preparedQuery);
        if (collectionMatcher.find()) {
            String collectionName = AqlUtils.buildCollectionName(this.operations.collection(this.domainClass).name());
            preparedQuery = collectionMatcher.replaceAll(collectionName);
        }
        if (accessor.getParameters().hasPageableParameter()) {
            String pageableClause = AqlUtils.buildPageableClause(accessor.getPageable());
            preparedQuery = PAGEABLE_PLACEHOLDER_PATTERN.matcher(preparedQuery).replaceFirst(pageableClause);
        } else if (accessor.getParameters().hasSortParameter()) {
            String sortClause = AqlUtils.buildSortClause(accessor.getSort());
            preparedQuery = SORT_PLACEHOLDER_PATTERN.matcher(preparedQuery).replaceFirst(sortClause);
        }
        return preparedQuery;
    }

    private void extractBindVars(ArangoParameterAccessor accessor, Map<String, Object> bindVars) {
        Map<String, Object> bindVarsInParams = accessor.getBindVars();
        if (bindVarsInParams != null) {
            bindVars.putAll(bindVarsInParams);
        }
        ArangoParameters bindableParams = (ArangoParameters)accessor.getParameters().getBindableParameters();
        int bindableParamsSize = bindableParams.getNumberOfParameters();
        for (int i = 0; i < bindableParamsSize; ++i) {
            ArangoParameters.ArangoParameter param = (ArangoParameters.ArangoParameter)bindableParams.getParameter(i);
            Object value = accessor.getBindableValue(i);
            if (param.isNamedParameter()) {
                bindVars.put((String)param.getName().get(), value);
                continue;
            }
            String key = String.valueOf(param.getIndex());
            String collectionKey = "@" + key;
            if (this.queryBindParams.contains(collectionKey)) {
                bindVars.put(collectionKey, value);
                continue;
            }
            bindVars.put(key, value);
        }
    }

    private Set<String> getBindParamsInQuery() {
        String fixedQuery = this.removeAqlStringLiterals(this.query);
        HashSet<String> bindings = new HashSet<String>();
        Matcher matcher = BIND_PARAM_PATTERN.matcher(fixedQuery);
        while (matcher.find()) {
            bindings.add(matcher.group(1));
        }
        return bindings;
    }

    private String removeAqlStringLiterals(String query) {
        StringBuilder fixedQuery = new StringBuilder();
        for (int i = 0; i < query.length(); ++i) {
            if (query.charAt(i) == '\"') {
                ++i;
                while (i < query.length()) {
                    if (query.charAt(i) == '\"') {
                        ++i;
                        break;
                    }
                    if (query.charAt(i) == '\\') {
                        ++i;
                    }
                    ++i;
                }
            } else if (query.charAt(i) == '\'') {
                ++i;
                while (i < query.length()) {
                    if (query.charAt(i) == '\'') {
                        ++i;
                        break;
                    }
                    if (query.charAt(i) == '\\') {
                        ++i;
                    }
                    ++i;
                }
            }
            fixedQuery.append(query.charAt(i));
        }
        return fixedQuery.toString();
    }

    private void assertSinglePageablePlaceholder() {
        if (this.method.getParameters().hasPageableParameter()) {
            int firstOccurrence = this.query.indexOf(PAGEABLE_PLACEHOLDER);
            int secondOccurrence = this.query.indexOf(PAGEABLE_PLACEHOLDER, firstOccurrence + PAGEABLE_PLACEHOLDER.length());
            Assert.isTrue((firstOccurrence > -1 && secondOccurrence < 0 ? 1 : 0) != 0, (String)String.format("Native query with Pageable param must contain exactly one pageable placeholder (%s)! Offending method: %s", new Object[]{PAGEABLE_PLACEHOLDER, this.method}));
        }
    }

    private void assertSingleSortPlaceholder() {
        if (this.method.getParameters().hasSortParameter()) {
            int firstOccurrence = this.query.indexOf(SORT_PLACEHOLDER);
            int secondOccurrence = this.query.indexOf(SORT_PLACEHOLDER, firstOccurrence + SORT_PLACEHOLDER.length());
            Assert.isTrue((firstOccurrence > -1 && secondOccurrence < 0 ? 1 : 0) != 0, (String)String.format("Native query with Sort param must contain exactly one sort placeholder (%s)! Offending method: %s", new Object[]{SORT_PLACEHOLDER, this.method}));
        }
    }
}

