/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.template;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.UserEntity;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import com.arangodb.springframework.core.CollectionOperations;
import com.arangodb.springframework.core.UserOperations;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public class DefaultUserOperation
implements UserOperations {
    private final ArangoDatabase db;
    private final String username;
    private final PersistenceExceptionTranslator exceptionTranslator;
    private final CollectionCallback collectionCallback;

    protected DefaultUserOperation(ArangoDatabase db, String username, PersistenceExceptionTranslator exceptionTranslator, CollectionCallback collectionCallback) {
        this.db = db;
        this.username = username;
        this.exceptionTranslator = exceptionTranslator;
        this.collectionCallback = collectionCallback;
    }

    private DataAccessException translateExceptionIfPossible(RuntimeException exception) {
        return this.exceptionTranslator.translateExceptionIfPossible(exception);
    }

    @Override
    public UserEntity get() throws DataAccessException {
        try {
            return this.db.arango().getUser(this.username);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public UserEntity create(String passwd, UserCreateOptions options) throws DataAccessException {
        try {
            return this.db.arango().createUser(this.username, passwd);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public UserEntity update(UserUpdateOptions options) throws DataAccessException {
        try {
            return this.db.arango().updateUser(this.username, options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public UserEntity replace(UserUpdateOptions options) throws DataAccessException {
        try {
            return this.db.arango().replaceUser(this.username, options);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public void delete() throws DataAccessException {
        try {
            this.db.arango().deleteUser(this.username);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public void grantDefaultDatabaseAccess(Permissions permissions) throws DataAccessException {
        try {
            this.db.arango().grantDefaultDatabaseAccess(this.username, permissions);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public void grantDatabaseAccess(Permissions permissions) throws DataAccessException {
        try {
            this.db.grantAccess(this.username, permissions);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public void resetDatabaseAccess() throws DataAccessException {
        try {
            this.db.resetAccess(this.username);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public void grantDefaultCollectionAccess(Permissions permissions) throws DataAccessException {
        try {
            this.db.grantDefaultCollectionAccess(this.username, permissions);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public void grantCollectionAccess(Class<?> type, Permissions permissions) throws DataAccessException {
        this.collectionCallback.collection(type).grantAccess(this.username, permissions);
    }

    @Override
    public void grantCollectionAccess(String name, Permissions permissions) throws DataAccessException {
        this.collectionCallback.collection(name).grantAccess(this.username, permissions);
    }

    @Override
    public void resetCollectionAccess(Class<?> type) throws DataAccessException {
        this.collectionCallback.collection(type).resetAccess(this.username);
    }

    @Override
    public void resetCollectionAccess(String name) throws DataAccessException {
        this.collectionCallback.collection(name).resetAccess(this.username);
    }

    @Override
    public Permissions getDatabasePermissions() throws DataAccessException {
        try {
            return this.db.getPermissions(this.username);
        }
        catch (ArangoDBException e) {
            throw this.translateExceptionIfPossible((RuntimeException)((Object)e));
        }
    }

    @Override
    public Permissions getCollectionPermissions(Class<?> type) throws DataAccessException {
        return this.collectionCallback.collection(type).getPermissions(this.username);
    }

    @Override
    public Permissions getCollectionPermissions(String name) throws DataAccessException {
        return this.collectionCallback.collection(name).getPermissions(name);
    }

    public static interface CollectionCallback {
        public CollectionOperations collection(Class<?> var1);

        public CollectionOperations collection(String var1);
    }
}

