/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.template;

import com.arangodb.ArangoCursor;
import com.arangodb.entity.CursorEntity;
import com.arangodb.internal.ArangoCursorExecute;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.cursor.ArangoCursorIterator;
import com.arangodb.springframework.core.convert.ArangoConverter;
import com.arangodb.springframework.core.mapping.event.AfterLoadEvent;
import com.arangodb.springframework.core.mapping.event.ArangoMappingEvent;
import com.arangodb.velocypack.VPackSlice;
import org.springframework.context.ApplicationEventPublisher;

class ArangoExtCursorIterator<T>
extends ArangoCursorIterator<T> {
    private ArangoConverter converter;
    private ApplicationEventPublisher eventPublisher;

    protected ArangoExtCursorIterator(ArangoCursor<T> cursor, InternalArangoDatabase<?, ?> db, ArangoCursorExecute execute, CursorEntity result) {
        super(cursor, execute, db, result);
    }

    public void setConverter(ArangoConverter converter) {
        this.converter = converter;
    }

    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected <R> R deserialize(VPackSlice source, Class<R> type) {
        Object result = this.converter.read(type, source);
        if (result != null) {
            this.potentiallyEmitEvent(new AfterLoadEvent<Object>(result));
        }
        return (R)result;
    }

    private void potentiallyEmitEvent(ArangoMappingEvent<?> event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }
}

