/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.mapping.event;

import com.arangodb.springframework.core.mapping.event.AbstractDeleteEvent;
import com.arangodb.springframework.core.mapping.event.AfterDeleteEvent;
import com.arangodb.springframework.core.mapping.event.AfterLoadEvent;
import com.arangodb.springframework.core.mapping.event.AfterSaveEvent;
import com.arangodb.springframework.core.mapping.event.ArangoMappingEvent;
import com.arangodb.springframework.core.mapping.event.BeforeDeleteEvent;
import com.arangodb.springframework.core.mapping.event.BeforeSaveEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;

public abstract class AbstractArangoEventListener<T>
implements ApplicationListener<ArangoMappingEvent<?>> {
    private final Class<?> domainClass;

    public AbstractArangoEventListener() {
        Class<Object> typeArgument = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractArangoEventListener.class);
        this.domainClass = typeArgument != null ? typeArgument : Object.class;
    }

    public final void onApplicationEvent(ArangoMappingEvent<?> event) {
        Object source = event.getSource();
        if (source == null) {
            return;
        }
        if (event instanceof AbstractDeleteEvent) {
            Class eventDomainClass = ((AbstractDeleteEvent)event).getType();
            if (eventDomainClass != null && this.domainClass.isAssignableFrom(eventDomainClass)) {
                if (event instanceof BeforeDeleteEvent) {
                    this.onBeforeDelete((BeforeDeleteEvent)event);
                } else if (event instanceof AfterDeleteEvent) {
                    this.onAfterDelete((AfterDeleteEvent)event);
                }
            }
            return;
        }
        if (!this.domainClass.isAssignableFrom(source.getClass())) {
            return;
        }
        if (event instanceof AfterLoadEvent) {
            this.onAfterLoad((AfterLoadEvent)event);
        } else if (event instanceof BeforeSaveEvent) {
            this.onBeforeSave((BeforeSaveEvent)event);
        } else if (event instanceof AfterSaveEvent) {
            this.onAfterSave((AfterSaveEvent)event);
        }
    }

    public void onAfterLoad(AfterLoadEvent<T> event) {
    }

    public void onBeforeSave(BeforeSaveEvent<T> event) {
    }

    public void onAfterSave(AfterSaveEvent<T> event) {
    }

    public void onBeforeDelete(BeforeDeleteEvent<T> event) {
    }

    public void onAfterDelete(AfterDeleteEvent<T> event) {
    }
}

