/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.mapping;

import com.arangodb.entity.CollectionType;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.springframework.annotation.Document;
import com.arangodb.springframework.annotation.Edge;
import com.arangodb.springframework.annotation.FulltextIndex;
import com.arangodb.springframework.annotation.FulltextIndexes;
import com.arangodb.springframework.annotation.GeoIndex;
import com.arangodb.springframework.annotation.GeoIndexes;
import com.arangodb.springframework.annotation.HashIndex;
import com.arangodb.springframework.annotation.HashIndexes;
import com.arangodb.springframework.annotation.PersistentIndex;
import com.arangodb.springframework.annotation.PersistentIndexes;
import com.arangodb.springframework.annotation.SkiplistIndex;
import com.arangodb.springframework.annotation.SkiplistIndexes;
import com.arangodb.springframework.annotation.TtlIndex;
import com.arangodb.springframework.core.mapping.ArangoIdPropertyIdentifierAccessor;
import com.arangodb.springframework.core.mapping.ArangoPersistentEntity;
import com.arangodb.springframework.core.mapping.ArangoPersistentProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.TargetAwareIdentifierAccessor;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DefaultArangoPersistentEntity<T>
extends BasicPersistentEntity<T, ArangoPersistentProperty>
implements ArangoPersistentEntity<T> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private String collection;
    private final Expression expression;
    private final StandardEvaluationContext context;
    private ArangoPersistentProperty arangoIdProperty;
    private ArangoPersistentProperty revProperty;
    private ArangoPersistentProperty ttlIndexedProperty;
    private final Collection<ArangoPersistentProperty> hashIndexedProperties;
    private final Collection<ArangoPersistentProperty> skiplistIndexedProperties;
    private final Collection<ArangoPersistentProperty> persistentIndexedProperties;
    private final Collection<ArangoPersistentProperty> geoIndexedProperties;
    private final Collection<ArangoPersistentProperty> fulltextIndexedProperties;
    private final CollectionCreateOptions collectionOptions;
    private final Map<Class<? extends Annotation>, Set<? extends Annotation>> repeatableAnnotationCache;

    public DefaultArangoPersistentEntity(TypeInformation<T> information) {
        super(information);
        this.collection = StringUtils.uncapitalize((String)information.getType().getSimpleName());
        this.context = new StandardEvaluationContext();
        this.hashIndexedProperties = new ArrayList<ArangoPersistentProperty>();
        this.skiplistIndexedProperties = new ArrayList<ArangoPersistentProperty>();
        this.persistentIndexedProperties = new ArrayList<ArangoPersistentProperty>();
        this.geoIndexedProperties = new ArrayList<ArangoPersistentProperty>();
        this.fulltextIndexedProperties = new ArrayList<ArangoPersistentProperty>();
        this.repeatableAnnotationCache = new HashMap<Class<? extends Annotation>, Set<? extends Annotation>>();
        Document document = (Document)this.findAnnotation(Document.class);
        Edge edge = (Edge)this.findAnnotation(Edge.class);
        if (edge != null) {
            this.collection = StringUtils.hasText((String)edge.value()) ? edge.value() : this.collection;
            this.collectionOptions = DefaultArangoPersistentEntity.createCollectionOptions(edge);
        } else if (document != null) {
            this.collection = StringUtils.hasText((String)document.value()) ? document.value() : this.collection;
            this.collectionOptions = DefaultArangoPersistentEntity.createCollectionOptions(document);
        } else {
            this.collectionOptions = new CollectionCreateOptions().type(CollectionType.DOCUMENT);
        }
        this.expression = PARSER.parseExpression(this.collection, ParserContext.TEMPLATE_EXPRESSION);
    }

    private static CollectionCreateOptions createCollectionOptions(Document annotation) {
        String[] shardKeys;
        CollectionCreateOptions options = new CollectionCreateOptions().type(CollectionType.DOCUMENT).waitForSync(Boolean.valueOf(annotation.waitForSync())).doCompact(Boolean.valueOf(annotation.doCompact())).isVolatile(Boolean.valueOf(annotation.isVolatile())).isSystem(Boolean.valueOf(annotation.isSystem()));
        if (annotation.journalSize() > -1L) {
            options.journalSize(Long.valueOf(annotation.journalSize()));
        }
        if (annotation.replicationFactor() > -1) {
            options.replicationFactor(Integer.valueOf(annotation.replicationFactor()));
        }
        if (annotation.satellite()) {
            options.satellite(Boolean.valueOf(annotation.satellite()));
        }
        if ((shardKeys = annotation.shardKeys()).length > 1 || shardKeys.length > 0 && StringUtils.hasText((String)shardKeys[0])) {
            options.shardKeys(shardKeys);
        }
        if (annotation.numberOfShards() > -1) {
            options.numberOfShards(Integer.valueOf(annotation.numberOfShards()));
        }
        if (annotation.indexBuckets() > -1) {
            options.indexBuckets(Integer.valueOf(annotation.indexBuckets()));
        }
        if (annotation.allowUserKeys()) {
            options.keyOptions(Boolean.valueOf(annotation.allowUserKeys()), annotation.keyType(), annotation.keyIncrement() > -1 ? Integer.valueOf(annotation.keyIncrement()) : null, annotation.keyOffset() > -1 ? Integer.valueOf(annotation.keyOffset()) : null);
        }
        return options;
    }

    private static CollectionCreateOptions createCollectionOptions(Edge annotation) {
        String[] shardKeys;
        CollectionCreateOptions options = new CollectionCreateOptions().type(CollectionType.EDGES).waitForSync(Boolean.valueOf(annotation.waitForSync())).doCompact(Boolean.valueOf(annotation.doCompact())).isVolatile(Boolean.valueOf(annotation.isVolatile())).isSystem(Boolean.valueOf(annotation.isSystem()));
        if (annotation.journalSize() > -1L) {
            options.journalSize(Long.valueOf(annotation.journalSize()));
        }
        if (annotation.replicationFactor() > -1) {
            options.replicationFactor(Integer.valueOf(annotation.replicationFactor()));
        }
        if ((shardKeys = annotation.shardKeys()).length > 0) {
            options.shardKeys(shardKeys);
        }
        if (annotation.numberOfShards() > -1) {
            options.numberOfShards(Integer.valueOf(annotation.numberOfShards()));
        }
        if (annotation.indexBuckets() > -1) {
            options.indexBuckets(Integer.valueOf(annotation.indexBuckets()));
        }
        if (annotation.allowUserKeys()) {
            options.keyOptions(Boolean.valueOf(annotation.allowUserKeys()), annotation.keyType(), annotation.keyIncrement() > -1 ? Integer.valueOf(annotation.keyIncrement()) : null, annotation.keyOffset() > -1 ? Integer.valueOf(annotation.keyOffset()) : null);
        }
        return options;
    }

    @Override
    public String getCollection() {
        return this.expression != null ? (String)this.expression.getValue((EvaluationContext)this.context, String.class) : this.collection;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.setRootObject((Object)applicationContext);
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
    }

    public void addPersistentProperty(ArangoPersistentProperty property) {
        super.addPersistentProperty((PersistentProperty)property);
        if (property.isArangoIdProperty()) {
            if (this.arangoIdProperty != null) {
                throw new MappingException("Found multiple id indexed properties!");
            }
            this.arangoIdProperty = property;
        }
        if (property.isRevProperty()) {
            if (this.revProperty != null) {
                throw new MappingException("Found multiple rev indexed properties!");
            }
            this.revProperty = property;
        }
        if (property.getTtlIndexed().isPresent()) {
            if (this.ttlIndexedProperty != null) {
                throw new MappingException("Found multiple ttl indexed properties!");
            }
            this.ttlIndexedProperty = property;
        }
        property.getHashIndexed().ifPresent(i -> this.hashIndexedProperties.add(property));
        property.getSkiplistIndexed().ifPresent(i -> this.skiplistIndexedProperties.add(property));
        property.getPersistentIndexed().ifPresent(i -> this.persistentIndexedProperties.add(property));
        property.getGeoIndexed().ifPresent(i -> this.geoIndexedProperties.add(property));
        property.getFulltextIndexed().ifPresent(i -> this.fulltextIndexedProperties.add(property));
    }

    @Override
    public Optional<ArangoPersistentProperty> getArangoIdProperty() {
        return Optional.ofNullable(this.arangoIdProperty);
    }

    @Override
    public Optional<ArangoPersistentProperty> getRevProperty() {
        return Optional.ofNullable(this.revProperty);
    }

    @Override
    public CollectionCreateOptions getCollectionOptions() {
        return this.collectionOptions;
    }

    @Override
    public Collection<HashIndex> getHashIndexes() {
        Collection<HashIndex> indexes = this.getIndexes(HashIndex.class);
        Optional.ofNullable(this.findAnnotation(HashIndexes.class)).ifPresent(i -> indexes.addAll(Arrays.asList(i.value())));
        return indexes;
    }

    @Override
    public Collection<SkiplistIndex> getSkiplistIndexes() {
        Collection<SkiplistIndex> indexes = this.getIndexes(SkiplistIndex.class);
        Optional.ofNullable(this.findAnnotation(SkiplistIndexes.class)).ifPresent(i -> indexes.addAll(Arrays.asList(i.value())));
        return indexes;
    }

    @Override
    public Collection<PersistentIndex> getPersistentIndexes() {
        Collection<PersistentIndex> indexes = this.getIndexes(PersistentIndex.class);
        Optional.ofNullable(this.findAnnotation(PersistentIndexes.class)).ifPresent(i -> indexes.addAll(Arrays.asList(i.value())));
        return indexes;
    }

    @Override
    public Collection<GeoIndex> getGeoIndexes() {
        Collection<GeoIndex> indexes = this.getIndexes(GeoIndex.class);
        Optional.ofNullable(this.findAnnotation(GeoIndexes.class)).ifPresent(i -> indexes.addAll(Arrays.asList(i.value())));
        return indexes;
    }

    @Override
    public Collection<FulltextIndex> getFulltextIndexes() {
        Collection<FulltextIndex> indexes = this.getIndexes(FulltextIndex.class);
        Optional.ofNullable(this.findAnnotation(FulltextIndexes.class)).ifPresent(i -> indexes.addAll(Arrays.asList(i.value())));
        return indexes;
    }

    @Override
    public Optional<TtlIndex> getTtlIndex() {
        return this.getIndex(TtlIndex.class);
    }

    private <A extends Annotation> Optional<A> getIndex(Class<A> annotation) {
        return Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.getType(), annotation));
    }

    public <A extends Annotation> Collection<A> getIndexes(Class<A> annotation) {
        List indexes = this.findAnnotations(annotation).stream().filter(a -> annotation.isInstance(a)).map(a -> (Annotation)annotation.cast(a)).collect(Collectors.toList());
        return indexes;
    }

    @Override
    public Collection<ArangoPersistentProperty> getHashIndexedProperties() {
        return this.hashIndexedProperties;
    }

    @Override
    public Collection<ArangoPersistentProperty> getSkiplistIndexedProperties() {
        return this.skiplistIndexedProperties;
    }

    @Override
    public Collection<ArangoPersistentProperty> getPersistentIndexedProperties() {
        return this.persistentIndexedProperties;
    }

    @Override
    public Collection<ArangoPersistentProperty> getGeoIndexedProperties() {
        return this.geoIndexedProperties;
    }

    @Override
    public Collection<ArangoPersistentProperty> getFulltextIndexedProperties() {
        return this.fulltextIndexedProperties;
    }

    @Override
    public Optional<ArangoPersistentProperty> getTtlIndexedProperty() {
        return Optional.ofNullable(this.ttlIndexedProperty);
    }

    public <A extends Annotation> Set<A> findAnnotations(Class<A> annotationType) {
        return this.repeatableAnnotationCache.computeIfAbsent(annotationType, it -> AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)this.getType(), (Class)it));
    }

    @Override
    public IdentifierAccessor getArangoIdAccessor(Object bean) {
        return this.getArangoIdProperty().isPresent() ? new ArangoIdPropertyIdentifierAccessor(this, bean) : new AbsentAccessor(bean);
    }

    private static class AbsentAccessor
    extends TargetAwareIdentifierAccessor {
        public AbsentAccessor(Object target) {
            super(target);
        }

        @Nullable
        public Object getIdentifier() {
            return null;
        }
    }
}

