/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.mapping;

import com.arangodb.springframework.core.convert.DBDocumentEntity;
import com.arangodb.velocypack.VPackSlice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public final class ArangoSimpleTypes {
    private static final Set<Class<?>> ARANGO_SIMPLE_TYPES;
    public static final SimpleTypeHolder HOLDER;

    private ArangoSimpleTypes() {
    }

    static {
        HashSet<Class<ZonedDateTime>> simpleTypes = new HashSet<Class<ZonedDateTime>>();
        simpleTypes.add(VPackSlice.class);
        simpleTypes.add(DBDocumentEntity.class);
        simpleTypes.add(BigInteger.class);
        simpleTypes.add(BigDecimal.class);
        simpleTypes.add(Date.class);
        simpleTypes.add(Timestamp.class);
        simpleTypes.add(Instant.class);
        simpleTypes.add(LocalDate.class);
        simpleTypes.add(LocalDateTime.class);
        simpleTypes.add(OffsetDateTime.class);
        simpleTypes.add(ZonedDateTime.class);
        ARANGO_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
        HOLDER = new SimpleTypeHolder(ARANGO_SIMPLE_TYPES, true);
    }
}

