/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.convert.resolver;

import com.arangodb.springframework.annotation.Ref;
import com.arangodb.springframework.core.ArangoOperations;
import com.arangodb.springframework.core.convert.resolver.AbstractResolver;
import com.arangodb.springframework.core.convert.resolver.ReferenceResolver;
import com.arangodb.springframework.core.mapping.ArangoPersistentEntity;
import com.arangodb.springframework.core.util.MetadataUtils;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.data.util.TypeInformation;

public class RefResolver
extends AbstractResolver<Ref>
implements ReferenceResolver<Ref>,
AbstractResolver.ResolverCallback<Ref> {
    private final ArangoOperations template;

    public RefResolver(ArangoOperations template) {
        super(template.getConverter().getConversionService());
        this.template = template;
    }

    @Override
    public Object resolveOne(String id, TypeInformation<?> type, Ref annotation) {
        return annotation.lazy() ? this.proxy(id, type, annotation, this) : this.resolve(id, type, annotation);
    }

    @Override
    public Object resolveMultiple(Collection<String> ids, TypeInformation<?> type, Ref annotation) {
        return ids.stream().map(id -> this.resolveOne((String)id, RefResolver.getNonNullComponentType(type), annotation)).collect(Collectors.toList());
    }

    @Override
    public Object resolve(String id, TypeInformation<?> type, Ref annotation) {
        return this.template.find(id, type.getType()).get();
    }

    @Override
    public String write(Object source, ArangoPersistentEntity<?> entity, Object id, Ref annotation) {
        return MetadataUtils.createIdFromCollectionAndKey(entity.getCollection(), String.valueOf(id));
    }
}

