/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.convert;

import com.arangodb.springframework.core.convert.JodaTimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.ClassUtils;

public class JodaTimeStringConverters {
    private static final boolean JODA_TIME_IS_PRESENT = ClassUtils.isPresent((String)"org.joda.time.LocalDate", null);

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!JODA_TIME_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(InstantToStringConverter.INSTANCE);
        converters.add(DateTimeToStringConverter.INSTANCE);
        converters.add(LocalDateToStringConverter.INSTANCE);
        converters.add(LocalDateTimeToStringConverter.INSTANCE);
        converters.add(StringToInstantConverter.INSTANCE);
        converters.add(StringToDateTimeConverter.INSTANCE);
        converters.add(StringToLocalDateConverter.INSTANCE);
        converters.add(StringToLocalDateTimeConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public static enum StringToLocalDateTimeConverter implements Converter<String, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(String source) {
            return source == null ? null : JodaTimeUtil.parseLocalDateTime(source);
        }
    }

    @ReadingConverter
    public static enum StringToLocalDateConverter implements Converter<String, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(String source) {
            return source == null ? null : JodaTimeUtil.parseLocalDate(source);
        }
    }

    @ReadingConverter
    public static enum StringToDateTimeConverter implements Converter<String, DateTime>
    {
        INSTANCE;


        public DateTime convert(String source) {
            return source == null ? null : JodaTimeUtil.parseDateTime(source);
        }
    }

    @ReadingConverter
    public static enum StringToInstantConverter implements Converter<String, Instant>
    {
        INSTANCE;


        public Instant convert(String source) {
            return source == null ? null : JodaTimeUtil.parseInstant(source);
        }
    }

    @WritingConverter
    public static enum LocalDateTimeToStringConverter implements Converter<LocalDateTime, String>
    {
        INSTANCE;


        public String convert(LocalDateTime source) {
            return source == null ? null : JodaTimeUtil.format(source);
        }
    }

    @WritingConverter
    public static enum LocalDateToStringConverter implements Converter<LocalDate, String>
    {
        INSTANCE;


        public String convert(LocalDate source) {
            return source == null ? null : JodaTimeUtil.format(source);
        }
    }

    @WritingConverter
    public static enum DateTimeToStringConverter implements Converter<DateTime, String>
    {
        INSTANCE;


        public String convert(DateTime source) {
            return source == null ? null : JodaTimeUtil.format(source);
        }
    }

    @WritingConverter
    public static enum InstantToStringConverter implements Converter<Instant, String>
    {
        INSTANCE;


        public String convert(Instant source) {
            return source == null ? null : JodaTimeUtil.format(source);
        }
    }
}

