/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.convert;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class JavaTimeUtil {
    private JavaTimeUtil() {
    }

    public static String format(Instant source) {
        return DateTimeFormatter.ISO_INSTANT.format(source);
    }

    public static String format(LocalDate source) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(source);
    }

    public static String format(OffsetDateTime source) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(source);
    }

    public static String format(LocalDateTime source) {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(source);
    }

    public static String format(ZonedDateTime source) {
        return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(source);
    }

    public static Instant parseInstant(CharSequence source) {
        return Instant.parse(source);
    }

    public static LocalDate parseLocalDate(CharSequence source) {
        return LocalDate.parse(source);
    }

    public static LocalDateTime parseLocalDateTime(CharSequence source) {
        return LocalDateTime.parse(source);
    }

    public static OffsetDateTime parseOffsetDateTime(CharSequence source) {
        return OffsetDateTime.parse(source);
    }

    public static ZonedDateTime parseZonedDateTime(CharSequence source) {
        return ZonedDateTime.parse(source);
    }
}

