/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;

public class ArangoConverters {
    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        converters.add(StringToUuidConverter.INSTANCE);
        converters.add(UuidToStringConverter.INSTANCE);
        return converters;
    }

    @WritingConverter
    public static enum UuidToStringConverter implements Converter<UUID, String>
    {
        INSTANCE;


        public String convert(UUID source) {
            return source == null ? null : source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToUuidConverter implements Converter<String, UUID>
    {
        INSTANCE;


        public UUID convert(String source) {
            return source == null ? null : UUID.fromString(source);
        }
    }
}

