/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.config;

import com.arangodb.springframework.annotation.Document;
import com.arangodb.springframework.annotation.Edge;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.TypeAlias;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ArangoEntityClassScanner {
    private static final Class<? extends Annotation>[] ENTITY_ANNOTATIONS = new Class[]{Document.class, Edge.class};
    private static final Class<? extends Annotation>[] ADDITIONAL_ANNOTATIONS = new Class[]{TypeAlias.class};

    public static Set<Class<?>> scanForEntities(String ... basePackages) throws ClassNotFoundException {
        HashSet entities = new HashSet();
        for (String basePackage : basePackages) {
            entities.addAll(ArangoEntityClassScanner.scanForEntities(basePackage));
        }
        return entities;
    }

    public static Set<Class<?>> scanForEntities(String basePackage) throws ClassNotFoundException {
        HashSet entities = new HashSet();
        if (StringUtils.hasText((String)basePackage)) {
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            for (Class<? extends Annotation> annotationType : ENTITY_ANNOTATIONS) {
                componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
            }
            for (Class<? extends Annotation> annotationType : ADDITIONAL_ANNOTATIONS) {
                componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
            }
            for (BeanDefinition definition : componentProvider.findCandidateComponents(basePackage)) {
                entities.add(ClassUtils.forName((String)definition.getBeanClassName(), null));
            }
        }
        return entities;
    }
}

