/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.springframework.config;

import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.springframework.annotation.Document;
import com.arangodb.springframework.annotation.Edge;
import com.arangodb.springframework.annotation.From;
import com.arangodb.springframework.annotation.Ref;
import com.arangodb.springframework.annotation.Relations;
import com.arangodb.springframework.annotation.To;
import com.arangodb.springframework.config.ArangoEntityClassScanner;
import com.arangodb.springframework.core.ArangoOperations;
import com.arangodb.springframework.core.convert.ArangoConverter;
import com.arangodb.springframework.core.convert.ArangoCustomConversions;
import com.arangodb.springframework.core.convert.ArangoTypeMapper;
import com.arangodb.springframework.core.convert.DefaultArangoConverter;
import com.arangodb.springframework.core.convert.DefaultArangoTypeMapper;
import com.arangodb.springframework.core.convert.resolver.AbstractResolver;
import com.arangodb.springframework.core.convert.resolver.DocumentFromResolver;
import com.arangodb.springframework.core.convert.resolver.DocumentToResolver;
import com.arangodb.springframework.core.convert.resolver.EdgeFromResolver;
import com.arangodb.springframework.core.convert.resolver.EdgeToResolver;
import com.arangodb.springframework.core.convert.resolver.RefResolver;
import com.arangodb.springframework.core.convert.resolver.ReferenceResolver;
import com.arangodb.springframework.core.convert.resolver.RelationResolver;
import com.arangodb.springframework.core.convert.resolver.RelationsResolver;
import com.arangodb.springframework.core.convert.resolver.ResolverFactory;
import com.arangodb.springframework.core.mapping.ArangoMappingContext;
import com.arangodb.springframework.core.mapping.ArangoPersistentEntity;
import com.arangodb.springframework.core.mapping.ArangoPersistentProperty;
import com.arangodb.springframework.core.template.ArangoTemplate;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;

public interface ArangoConfiguration {
    public ArangoDB.Builder arango();

    public String database();

    @Bean
    default public ArangoOperations arangoTemplate() throws Exception {
        return new ArangoTemplate(this.arango().build(), this.database(), this.arangoConverter(), this.resolverFactory());
    }

    @Bean
    default public ArangoMappingContext arangoMappingContext() throws Exception {
        ArangoMappingContext context = new ArangoMappingContext();
        context.setInitialEntitySet(this.getInitialEntitySet());
        context.setFieldNamingStrategy(this.fieldNamingStrategy());
        context.setSimpleTypeHolder(this.customConversions().getSimpleTypeHolder());
        return context;
    }

    @Bean
    default public ArangoConverter arangoConverter() throws Exception {
        return new DefaultArangoConverter((MappingContext<? extends ArangoPersistentEntity<?>, ArangoPersistentProperty>)this.arangoMappingContext(), this.customConversions(), this.resolverFactory(), this.arangoTypeMapper());
    }

    default public CustomConversions customConversions() {
        return new ArangoCustomConversions(this.customConverters());
    }

    default public Collection<Converter<?, ?>> customConverters() {
        return Collections.emptyList();
    }

    default public Set<? extends Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        return ArangoEntityClassScanner.scanForEntities(this.getEntityBasePackages());
    }

    default public String[] getEntityBasePackages() {
        return new String[]{this.getClass().getPackage().getName()};
    }

    default public FieldNamingStrategy fieldNamingStrategy() {
        return PropertyNameFieldNamingStrategy.INSTANCE;
    }

    default public String typeKey() {
        return "_class";
    }

    default public ArangoTypeMapper arangoTypeMapper() throws Exception {
        return new DefaultArangoTypeMapper(this.typeKey(), (MappingContext<? extends PersistentEntity<?, ?>, ?>)this.arangoMappingContext());
    }

    default public ResolverFactory resolverFactory() {
        return new ResolverFactory(){

            @Override
            public <A extends Annotation> Optional<ReferenceResolver<A>> getReferenceResolver(A annotation) {
                RefResolver resolver = null;
                try {
                    if (annotation instanceof Ref) {
                        resolver = new RefResolver(ArangoConfiguration.this.arangoTemplate());
                    }
                }
                catch (Exception e) {
                    throw new ArangoDBException((Throwable)e);
                }
                return Optional.ofNullable(resolver);
            }

            @Override
            public <A extends Annotation> Optional<RelationResolver<A>> getRelationResolver(A annotation, Class<? extends Annotation> collectionType) {
                AbstractResolver resolver = null;
                try {
                    if (annotation instanceof From) {
                        if (collectionType == Edge.class) {
                            resolver = new EdgeFromResolver(ArangoConfiguration.this.arangoTemplate());
                        } else if (collectionType == Document.class) {
                            resolver = new DocumentFromResolver(ArangoConfiguration.this.arangoTemplate());
                        }
                    } else if (annotation instanceof To) {
                        if (collectionType == Edge.class) {
                            resolver = new EdgeToResolver(ArangoConfiguration.this.arangoTemplate());
                        } else if (collectionType == Document.class) {
                            resolver = new DocumentToResolver(ArangoConfiguration.this.arangoTemplate());
                        }
                    } else if (annotation instanceof Relations) {
                        resolver = new RelationsResolver(ArangoConfiguration.this.arangoTemplate());
                    }
                }
                catch (Exception e) {
                    throw new ArangoDBException((Throwable)e);
                }
                return Optional.ofNullable(resolver);
            }
        };
    }
}

