/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.mapping;

import com.arangodb.entity.DocumentField;
import com.arangodb.velocypack.annotations.Expose;
import com.arangodb.velocypack.annotations.SerializedName;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;

public class ArangoAnnotationIntrospector
extends JacksonAnnotationIntrospector {
    public JsonProperty.Access findPropertyAccess(Annotated m) {
        if (!(m instanceof AnnotatedMember)) {
            return super.findPropertyAccess(m);
        }
        Expose expose = (Expose)m.getAnnotation(Expose.class);
        if (expose != null) {
            boolean serialize = expose.serialize();
            boolean deserialize = expose.deserialize();
            if (serialize && deserialize) {
                return JsonProperty.Access.READ_WRITE;
            }
            if (serialize) {
                return JsonProperty.Access.READ_ONLY;
            }
            if (deserialize) {
                return JsonProperty.Access.WRITE_ONLY;
            }
        }
        return super.findPropertyAccess(m);
    }

    public boolean hasIgnoreMarker(AnnotatedMember m) {
        Expose expose = (Expose)m.getAnnotation(Expose.class);
        if (expose != null && !expose.serialize() && !expose.deserialize()) {
            return true;
        }
        return super.hasIgnoreMarker(m);
    }

    public PropertyName findNameForSerialization(Annotated a) {
        PropertyName name = this.findPropertyName(a);
        if (name != null) {
            return name;
        }
        return super.findNameForSerialization(a);
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        PropertyName name = this.findPropertyName(a);
        if (name != null) {
            return name;
        }
        return super.findNameForDeserialization(a);
    }

    public String findImplicitPropertyName(AnnotatedMember member) {
        String name = this.findParameterName((Annotated)member);
        if (name != null) {
            return name;
        }
        return super.findImplicitPropertyName(member);
    }

    private String findParameterName(Annotated a) {
        if (!(a instanceof AnnotatedParameter)) {
            return null;
        }
        SerializedName serializedName = (SerializedName)a.getAnnotation(SerializedName.class);
        if (serializedName != null) {
            return serializedName.value();
        }
        return null;
    }

    private PropertyName findPropertyName(Annotated a) {
        if (!(a instanceof AnnotatedMember)) {
            return null;
        }
        DocumentField documentField = (DocumentField)a.getAnnotation(DocumentField.class);
        if (documentField != null) {
            return PropertyName.construct((String)documentField.value().getSerializeName());
        }
        SerializedName serializedName = (SerializedName)a.getAnnotation(SerializedName.class);
        if (serializedName != null) {
            return PropertyName.construct((String)serializedName.value());
        }
        return null;
    }
}

