/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.Entity;
import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Response;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public abstract class ArangoExecutor {
    private final DocumentCache documentCache;
    private final ArangoSerializationFactory util;

    protected <T> T createResult(Type type, Response response) {
        if (type != Void.class && response.getBody() != null) {
            if (this.isInternal(type)) {
                return this.util.get(ArangoSerializationFactory.Serializer.INTERNAL).deserialize(response.getBody(), type);
            }
            return this.util.get(ArangoSerializationFactory.Serializer.CUSTOM).deserialize(response.getBody(), type);
        }
        return null;
    }

    private boolean isInternal(Type type) {
        ParameterizedType pType;
        Type rawType;
        if (type instanceof ParameterizedType && (rawType = (pType = (ParameterizedType)type).getRawType()) instanceof Class && (Map.class.isAssignableFrom((Class)rawType) || Iterable.class.isAssignableFrom((Class)rawType))) {
            for (Type arg : pType.getActualTypeArguments()) {
                if (this.isInternal(arg)) continue;
                return false;
            }
            return true;
        }
        return type instanceof Class && Entity.class.isAssignableFrom((Class)type);
    }

    protected ArangoExecutor(ArangoSerializationFactory util, DocumentCache documentCache) {
        this.documentCache = documentCache;
        this.util = util;
    }

    public DocumentCache documentCache() {
        return this.documentCache;
    }

    public static interface ResponseDeserializer<T> {
        public T deserialize(Response var1) throws VPackException;
    }
}

