/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader;

import com.apptasticsoftware.rssreader.DateTimeParser;
import com.apptasticsoftware.rssreader.Item;
import com.apptasticsoftware.rssreader.util.Default;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Comparator;
import java.util.Locale;

public class DateTime
implements DateTimeParser {
    private final ZoneId defaultZone;
    private static final DateTimeFormatter BASIC_ISO_DATE = DateTimeFormatter.BASIC_ISO_DATE.withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter ISO_LOCAL_DATE = DateTimeFormatter.ISO_LOCAL_DATE.withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter ISO_OFFSET_DATE_TIME = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter ISO_OFFSET_DATE_TIME_SPECIAL;
    private static final DateTimeFormatter ISO_LOCAL_DATE_TIME;
    private static final DateTimeFormatter ISO_LOCAL_DATE_TIME_SPECIAL;
    private static final DateTimeFormatter RFC_1123_DATE_TIME;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_TIMEZONE;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_TIMEZONE2;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_NO_TIMEZONE;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_GMT_OFFSET;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_GMT_AND_OFFSET;
    private static final DateTimeFormatter RFC_822_DATE_TIME;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EST;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EDT;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CST;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CDT;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MST;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MDT;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PST;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PDT;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_FULL_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_GMT_OFFSET_FULL_DOW;
    private static final DateTimeFormatter RFC_822_DATE_TIME_FULL_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EST_FULL_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EDT_FULL_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CST_FULL_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CDT_FULL_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MST_FULL_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MDT_FULL_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PST_FULL_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PDT_FULL_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_FULL_DOW_MONTH;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_GMT_OFFSET_FULL_DOW_MONTH;
    private static final DateTimeFormatter RFC_822_DATE_TIME_FULL_DOW_MONTH;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EST_FULL_DOW_MONTH;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EDT_FULL_DOW_MONTH;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CST_FULL_DOW_MONTH;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CDT_FULL_DOW_MONTH;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MST_FULL_DOW_MONTH;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MDT_FULL_DOW_MONTH;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PST_FULL_DOW_MONTH;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PDT_FULL_DOW_MONTH;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_NO_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_GMT_OFFSET_NO_DOW;
    private static final DateTimeFormatter RFC_822_DATE_TIME_NO_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EST_NO_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_EDT_NO_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CST_NO_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_CDT_NO_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MST_NO_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_MDT_NO_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PST_NO_DOW;
    private static final DateTimeFormatter RFC_1123_DATE_TIME_SPECIAL_PDT_NO_DOW;
    private static final DateTimeFormatter DATE_TIME_SPECIAL_1;

    public DateTime() {
        this.defaultZone = ZoneId.of("UTC");
    }

    public DateTime(ZoneId defaultZone) {
        this.defaultZone = defaultZone;
    }

    public LocalDateTime toLocalDateTime(String dateTime) {
        ZonedDateTime zonedDateTime = this.toZonedDateTime(dateTime);
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.toLocalDateTime();
    }

    public ZonedDateTime toZonedDateTime(String dateTime) {
        if (dateTime == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTime.getDateTimeFormatter(dateTime, false);
        if (formatter == null) {
            throw new IllegalArgumentException("Unknown date time format " + dateTime);
        }
        if (dateTime.length() == 19) {
            LocalDateTime localDateTime = LocalDateTime.parse(dateTime, formatter);
            return ZonedDateTime.of(localDateTime, this.defaultZone);
        }
        if ((dateTime.length() == 29 || dateTime.length() == 32 || dateTime.length() == 35) && dateTime.charAt(10) == 'T' || (dateTime.length() == 24 || dateTime.length() == 25) && dateTime.charAt(3) == ',') {
            return ZonedDateTime.parse(dateTime, formatter);
        }
        try {
            if (DateTime.isDateOnly(formatter)) {
                LocalDate date = LocalDate.parse(dateTime, formatter);
                return ZonedDateTime.of(date, LocalTime.MIDNIGHT, this.defaultZone);
            }
            return ZonedDateTime.parse(dateTime, formatter);
        }
        catch (DateTimeParseException e) {
            int index = dateTime.indexOf(44);
            if (index != -1 && e.getMessage().contains("Conflict found: Field DayOfWeek")) {
                String newDateTime = dateTime.substring(index + 1).trim();
                try {
                    DateTimeFormatter newFormatter = DateTime.getDateTimeFormatter(newDateTime, true);
                    return ZonedDateTime.parse(newDateTime, newFormatter);
                }
                catch (DateTimeParseException e2) {
                    throw e;
                }
            }
            throw e;
        }
    }

    private static boolean isDateOnly(DateTimeFormatter formatter) {
        return formatter == ISO_LOCAL_DATE || formatter == BASIC_ISO_DATE;
    }

    private static DateTimeFormatter getDateTimeFormatter(String dateTime, boolean skipEndOfWeekPart) {
        if (skipEndOfWeekPart) {
            return DateTime.parseRfcDateTimeNoDayOfWeek(dateTime);
        }
        int index = dateTime.indexOf(44);
        if (index == -1) {
            index = dateTime.indexOf(32);
            if (Character.isDigit(dateTime.charAt(0)) && (index == 1 || index == 2)) {
                return DATE_TIME_SPECIAL_1;
            }
            return DateTime.parseIsoDateTime(dateTime);
        }
        if (index <= 3) {
            return DateTime.parseRfcDateTime(dateTime);
        }
        if (DateTime.isLongMonthText(dateTime)) {
            return DateTime.parseRfcDateTimeLongDayOfWeekLongMonth(dateTime);
        }
        return DateTime.parseRfcDateTimeLongDayOfWeek(dateTime);
    }

    private static boolean isLongMonthText(String dateTime) {
        int index1 = dateTime.indexOf(32);
        int index2 = dateTime.indexOf(32, index1 + 1);
        int index3 = dateTime.indexOf(32, index2 + 1);
        return index3 - index2 - 1 > 3;
    }

    private static DateTimeFormatter parseIsoDateTime(String dateTime) {
        if (dateTime.length() == 24 && dateTime.charAt(4) == '-' && dateTime.charAt(10) == 'T' && (dateTime.charAt(dateTime.length() - 5) == '-' || dateTime.charAt(dateTime.length() - 5) == '+')) {
            return ISO_OFFSET_DATE_TIME_SPECIAL;
        }
        if (dateTime.length() >= 20 && dateTime.length() <= 35 && dateTime.charAt(4) == '-' && dateTime.charAt(10) == 'T') {
            return ISO_OFFSET_DATE_TIME;
        }
        if (dateTime.length() == 19 && dateTime.charAt(10) == 'T') {
            return ISO_LOCAL_DATE_TIME;
        }
        if (dateTime.length() == 19 && dateTime.charAt(10) == ' ') {
            return ISO_LOCAL_DATE_TIME_SPECIAL;
        }
        if (dateTime.length() == 10 && dateTime.charAt(4) == '-' && dateTime.charAt(7) == '-') {
            return ISO_LOCAL_DATE;
        }
        if (dateTime.length() == 8) {
            return BASIC_ISO_DATE;
        }
        return null;
    }

    private static DateTimeFormatter parseRfcDateTime(String dateTime) {
        if ((dateTime.length() == 28 || dateTime.length() == 29) && dateTime.charAt(3) == ',' && dateTime.endsWith(" UTC")) {
            return RFC_1123_DATE_TIME_SPECIAL;
        }
        if (dateTime.length() <= 29 && dateTime.charAt(3) == ',' && dateTime.endsWith(" EDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_EDT;
        }
        if (dateTime.length() <= 29 && dateTime.charAt(3) == ',' && dateTime.endsWith(" EST")) {
            return RFC_1123_DATE_TIME_SPECIAL_EST;
        }
        if (dateTime.length() <= 29 && dateTime.charAt(3) == ',' && dateTime.endsWith(" CDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_CDT;
        }
        if (dateTime.length() <= 29 && dateTime.charAt(3) == ',' && dateTime.endsWith(" CST")) {
            return RFC_1123_DATE_TIME_SPECIAL_CST;
        }
        if (dateTime.length() <= 29 && dateTime.charAt(3) == ',' && dateTime.endsWith(" MDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_MDT;
        }
        if (dateTime.length() <= 29 && dateTime.charAt(3) == ',' && dateTime.endsWith(" MST")) {
            return RFC_1123_DATE_TIME_SPECIAL_MST;
        }
        if (dateTime.length() <= 29 && dateTime.charAt(3) == ',' && dateTime.endsWith(" PDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_PDT;
        }
        if (dateTime.length() <= 29 && dateTime.charAt(3) == ',' && dateTime.endsWith(" PST")) {
            return RFC_1123_DATE_TIME_SPECIAL_PST;
        }
        if (dateTime.length() > 31 && dateTime.contains("GMT") && !dateTime.endsWith("GMT") && dateTime.lastIndexOf(58) < 29) {
            return RFC_1123_DATE_TIME_GMT_AND_OFFSET;
        }
        if (dateTime.length() >= 28 && dateTime.length() <= 35 && dateTime.charAt(3) == ',' && dateTime.contains("GMT")) {
            return RFC_1123_DATE_TIME_GMT_OFFSET;
        }
        if (!(dateTime.length() != 28 && dateTime.length() != 29 || dateTime.charAt(3) != ',' || dateTime.charAt(13) != ' ' && dateTime.charAt(14) != ' ')) {
            return RFC_822_DATE_TIME;
        }
        if (dateTime.length() >= 28 && dateTime.length() <= 32) {
            if ((dateTime.contains(" +") || dateTime.contains(" -")) && dateTime.charAt(dateTime.length() - 3) == ':') {
                return RFC_1123_DATE_TIME_TIMEZONE;
            }
            if (dateTime.contains(" +") || dateTime.contains(" -")) {
                return RFC_1123_DATE_TIME;
            }
            if (dateTime.contains("+") || dateTime.contains("-")) {
                return RFC_1123_DATE_TIME_TIMEZONE2;
            }
            return RFC_1123_DATE_TIME_TIMEZONE;
        }
        if ((dateTime.length() == 26 || dateTime.length() == 27) && dateTime.charAt(3) == ',' && dateTime.endsWith(" Z")) {
            return RFC_1123_DATE_TIME_SPECIAL;
        }
        if ((dateTime.length() == 24 || dateTime.length() == 25) && dateTime.charAt(3) == ',') {
            return RFC_1123_DATE_TIME_NO_TIMEZONE;
        }
        return null;
    }

    private static DateTimeFormatter parseRfcDateTimeLongDayOfWeek(String dateTime) {
        if (dateTime.endsWith(" UTC")) {
            return RFC_1123_DATE_TIME_SPECIAL_FULL_DOW;
        }
        if (dateTime.endsWith(" EDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_EDT_FULL_DOW;
        }
        if (dateTime.endsWith(" EST")) {
            return RFC_1123_DATE_TIME_SPECIAL_EST_FULL_DOW;
        }
        if (dateTime.endsWith(" CDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_CDT_FULL_DOW;
        }
        if (dateTime.endsWith(" CST")) {
            return RFC_1123_DATE_TIME_SPECIAL_CST_FULL_DOW;
        }
        if (dateTime.endsWith(" MDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_MDT_FULL_DOW;
        }
        if (dateTime.endsWith(" MST")) {
            return RFC_1123_DATE_TIME_SPECIAL_MST_FULL_DOW;
        }
        if (dateTime.endsWith(" PDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_PDT_FULL_DOW;
        }
        if (dateTime.endsWith(" PST")) {
            return RFC_1123_DATE_TIME_SPECIAL_PST_FULL_DOW;
        }
        if (dateTime.contains("GMT")) {
            return RFC_1123_DATE_TIME_GMT_OFFSET_FULL_DOW;
        }
        if (dateTime.endsWith(" Z")) {
            return RFC_1123_DATE_TIME_SPECIAL_FULL_DOW;
        }
        if (dateTime.charAt(3) != ',' && dateTime.charAt(dateTime.length() - 3) == ':' && dateTime.charAt(dateTime.length() - 7) == ' ') {
            return RFC_1123_DATE_TIME_SPECIAL_FULL_DOW;
        }
        if (dateTime.contains("-") || dateTime.contains("+")) {
            return RFC_822_DATE_TIME_FULL_DOW;
        }
        return null;
    }

    private static DateTimeFormatter parseRfcDateTimeLongDayOfWeekLongMonth(String dateTime) {
        if (dateTime.endsWith(" UTC")) {
            return RFC_1123_DATE_TIME_SPECIAL_FULL_DOW_MONTH;
        }
        if (dateTime.endsWith(" EDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_EDT_FULL_DOW_MONTH;
        }
        if (dateTime.endsWith(" EST")) {
            return RFC_1123_DATE_TIME_SPECIAL_EST_FULL_DOW_MONTH;
        }
        if (dateTime.endsWith(" CDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_CDT_FULL_DOW_MONTH;
        }
        if (dateTime.endsWith(" CST")) {
            return RFC_1123_DATE_TIME_SPECIAL_CST_FULL_DOW_MONTH;
        }
        if (dateTime.endsWith(" MDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_MDT_FULL_DOW_MONTH;
        }
        if (dateTime.endsWith(" MST")) {
            return RFC_1123_DATE_TIME_SPECIAL_MST_FULL_DOW_MONTH;
        }
        if (dateTime.endsWith(" PDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_PDT_FULL_DOW_MONTH;
        }
        if (dateTime.endsWith(" PST")) {
            return RFC_1123_DATE_TIME_SPECIAL_PST_FULL_DOW_MONTH;
        }
        if (dateTime.contains("GMT")) {
            return RFC_1123_DATE_TIME_GMT_OFFSET_FULL_DOW_MONTH;
        }
        if (dateTime.endsWith(" Z")) {
            return RFC_1123_DATE_TIME_SPECIAL_FULL_DOW_MONTH;
        }
        if (dateTime.charAt(3) != ',' && dateTime.charAt(dateTime.length() - 3) == ':' && dateTime.charAt(dateTime.length() - 7) == ' ') {
            return RFC_1123_DATE_TIME_SPECIAL_FULL_DOW_MONTH;
        }
        if (dateTime.contains("-") || dateTime.contains("+")) {
            return RFC_822_DATE_TIME_FULL_DOW_MONTH;
        }
        return null;
    }

    private static DateTimeFormatter parseRfcDateTimeNoDayOfWeek(String dateTime) {
        if (dateTime.endsWith(" UTC")) {
            return RFC_1123_DATE_TIME_SPECIAL_NO_DOW;
        }
        if (dateTime.endsWith(" EDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_EDT_NO_DOW;
        }
        if (dateTime.endsWith(" EST")) {
            return RFC_1123_DATE_TIME_SPECIAL_EST_NO_DOW;
        }
        if (dateTime.endsWith(" CDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_CDT_NO_DOW;
        }
        if (dateTime.endsWith(" CST")) {
            return RFC_1123_DATE_TIME_SPECIAL_CST_NO_DOW;
        }
        if (dateTime.endsWith(" MDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_MDT_NO_DOW;
        }
        if (dateTime.endsWith(" MST")) {
            return RFC_1123_DATE_TIME_SPECIAL_MST_NO_DOW;
        }
        if (dateTime.endsWith(" PDT")) {
            return RFC_1123_DATE_TIME_SPECIAL_PDT_NO_DOW;
        }
        if (dateTime.endsWith(" PST")) {
            return RFC_1123_DATE_TIME_SPECIAL_PST_NO_DOW;
        }
        if (dateTime.contains("GMT")) {
            return RFC_1123_DATE_TIME_GMT_OFFSET_NO_DOW;
        }
        if (dateTime.endsWith(" Z")) {
            return RFC_1123_DATE_TIME_SPECIAL_NO_DOW;
        }
        if (dateTime.contains("-") || dateTime.contains("+")) {
            return RFC_822_DATE_TIME_NO_DOW;
        }
        return null;
    }

    public Long toEpochMilli(String dateTime) {
        ZonedDateTime zonedDateTime = this.toZonedDateTime(dateTime);
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.toInstant().toEpochMilli();
    }

    @Override
    public Instant toInstant(String dateTime) {
        ZonedDateTime zonedDateTime = this.toZonedDateTime(dateTime);
        if (zonedDateTime == null) {
            return null;
        }
        return zonedDateTime.toInstant();
    }

    @Deprecated(since="3.3.0", forRemoval=true)
    public static Comparator<Item> pubDateComparator() {
        DateTimeParser dateTime = Default.getDateTimeParser();
        return Comparator.comparing(i -> i.getPubDate().map(dateTime::toInstant).orElse(Instant.EPOCH));
    }

    @Override
    public ZonedDateTime parse(String timestamp) {
        return this.toZonedDateTime(timestamp);
    }

    static {
        ISO_LOCAL_DATE_TIME = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withLocale(Locale.ENGLISH);
        ISO_LOCAL_DATE_TIME_SPECIAL = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter().withLocale(Locale.ENGLISH);
        ISO_OFFSET_DATE_TIME_SPECIAL = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HHMM", "0000").toFormatter(Locale.ENGLISH);
        RFC_1123_DATE_TIME = DateTimeFormatter.RFC_1123_DATE_TIME.withLocale(Locale.ENGLISH);
        RFC_1123_DATE_TIME_TIMEZONE = DateTimeFormatter.ofPattern("E, d LLL yyyy H:m:s zzz", Locale.ENGLISH);
        RFC_1123_DATE_TIME_TIMEZONE2 = new DateTimeFormatterBuilder().appendPattern("E, d LLL yyyy H:m:s").appendOffset("+H:mm", "+00").toFormatter().withLocale(Locale.ENGLISH);
        RFC_1123_DATE_TIME_NO_TIMEZONE = DateTimeFormatter.ofPattern("E, d LLL yyyy H:m:s", Locale.ENGLISH).withZone(ZoneId.of("UTC"));
        RFC_1123_DATE_TIME_SPECIAL = DateTimeFormatter.ofPattern("E, d LLL yyyy H:m:s z", Locale.ENGLISH);
        RFC_1123_DATE_TIME_GMT_OFFSET = DateTimeFormatter.ofPattern("E, d LLL yyyy H:m:s O", Locale.ENGLISH);
        RFC_1123_DATE_TIME_GMT_AND_OFFSET = DateTimeFormatter.ofPattern("E, dd MMM yyyy H:m:s 'GMT'Z", Locale.ENGLISH);
        RFC_822_DATE_TIME = DateTimeFormatter.ofPattern("E, d LLL yy H:m:s X", Locale.ENGLISH);
        RFC_1123_DATE_TIME_SPECIAL_EDT = DateTimeFormatter.ofPattern("E, d LLL yyyy H:m:s 'EDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-4));
        RFC_1123_DATE_TIME_SPECIAL_EST = DateTimeFormatter.ofPattern("E, d LLL yyyy H:m:s 'EST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CDT = DateTimeFormatter.ofPattern("E, d LLL yyyy H:m:s 'CDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CST = DateTimeFormatter.ofPattern("E, d LLL yyyy H:m:s 'CST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MDT = DateTimeFormatter.ofPattern("E, d LLL yyyy H:m:s 'MDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MST = DateTimeFormatter.ofPattern("E, d LLL yyyy H:m:s 'MST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PDT = DateTimeFormatter.ofPattern("E, d LLL yyyy H:m:s 'PDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PST = DateTimeFormatter.ofPattern("E, d LLL yyyy H:m:s 'PST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-8));
        RFC_1123_DATE_TIME_SPECIAL_FULL_DOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy H:m:s z", Locale.ENGLISH);
        RFC_1123_DATE_TIME_GMT_OFFSET_FULL_DOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy H:m:s O", Locale.ENGLISH);
        RFC_822_DATE_TIME_FULL_DOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy H:m:s X", Locale.ENGLISH);
        RFC_1123_DATE_TIME_SPECIAL_EDT_FULL_DOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy H:m:s 'EDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-4));
        RFC_1123_DATE_TIME_SPECIAL_EST_FULL_DOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy H:m:s 'EST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CDT_FULL_DOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy H:m:s 'CDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CST_FULL_DOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy H:m:s 'CST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MDT_FULL_DOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy H:m:s 'MDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MST_FULL_DOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy H:m:s 'MST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PDT_FULL_DOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy H:m:s 'PDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PST_FULL_DOW = DateTimeFormatter.ofPattern("EEEE, d LLL yyyy H:m:s 'PST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-8));
        RFC_1123_DATE_TIME_SPECIAL_FULL_DOW_MONTH = DateTimeFormatter.ofPattern("EEEE, d LLLL yyyy H:m:s z", Locale.ENGLISH);
        RFC_1123_DATE_TIME_GMT_OFFSET_FULL_DOW_MONTH = DateTimeFormatter.ofPattern("EEEE, d LLLL yyyy H:m:s O", Locale.ENGLISH);
        RFC_822_DATE_TIME_FULL_DOW_MONTH = DateTimeFormatter.ofPattern("EEEE, d LLLL yyyy H:m:s X", Locale.ENGLISH);
        RFC_1123_DATE_TIME_SPECIAL_EDT_FULL_DOW_MONTH = DateTimeFormatter.ofPattern("EEEE, d LLLL yyyy H:m:s 'EDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-4));
        RFC_1123_DATE_TIME_SPECIAL_EST_FULL_DOW_MONTH = DateTimeFormatter.ofPattern("EEEE, d LLLL yyyy H:m:s 'EST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CDT_FULL_DOW_MONTH = DateTimeFormatter.ofPattern("EEEE, d LLLL yyyy H:m:s 'CDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CST_FULL_DOW_MONTH = DateTimeFormatter.ofPattern("EEEE, d LLLL yyyy H:m:s 'CST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MDT_FULL_DOW_MONTH = DateTimeFormatter.ofPattern("EEEE, d LLLL yyyy H:m:s 'MDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MST_FULL_DOW_MONTH = DateTimeFormatter.ofPattern("EEEE, d LLLL yyyy H:m:s 'MST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PDT_FULL_DOW_MONTH = DateTimeFormatter.ofPattern("EEEE, d LLLL yyyy H:m:s 'PDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PST_FULL_DOW_MONTH = DateTimeFormatter.ofPattern("EEEE, d LLLL yyyy H:m:s 'PST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-8));
        RFC_1123_DATE_TIME_SPECIAL_NO_DOW = DateTimeFormatter.ofPattern("d LLL yyyy H:m:s z", Locale.ENGLISH);
        RFC_1123_DATE_TIME_GMT_OFFSET_NO_DOW = DateTimeFormatter.ofPattern("d LLL yyyy H:m:s O", Locale.ENGLISH);
        RFC_822_DATE_TIME_NO_DOW = DateTimeFormatter.ofPattern("d LLL yyyy H:m:s X", Locale.ENGLISH);
        RFC_1123_DATE_TIME_SPECIAL_EDT_NO_DOW = DateTimeFormatter.ofPattern("d LLL yyyy H:m:s 'EDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-4));
        RFC_1123_DATE_TIME_SPECIAL_EST_NO_DOW = DateTimeFormatter.ofPattern("d LLL yyyy H:m:s 'EST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CDT_NO_DOW = DateTimeFormatter.ofPattern("d LLL yyyy H:m:s 'CDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-5));
        RFC_1123_DATE_TIME_SPECIAL_CST_NO_DOW = DateTimeFormatter.ofPattern("d LLL yyyy H:m:s 'CST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MDT_NO_DOW = DateTimeFormatter.ofPattern("d LLL yyyy H:m:s 'MDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-6));
        RFC_1123_DATE_TIME_SPECIAL_MST_NO_DOW = DateTimeFormatter.ofPattern("d LLL yyyy H:m:s 'MST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PDT_NO_DOW = DateTimeFormatter.ofPattern("d LLL yyyy H:m:s 'PDT'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-7));
        RFC_1123_DATE_TIME_SPECIAL_PST_NO_DOW = DateTimeFormatter.ofPattern("d LLL yyyy H:m:s 'PST'", Locale.ENGLISH).withZone(ZoneOffset.ofHours(-8));
        DATE_TIME_SPECIAL_1 = DateTimeFormatter.ofPattern("d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    }
}

