/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader;

import com.apptasticsoftware.rssreader.Channel;
import com.apptasticsoftware.rssreader.DateTimeParser;
import com.apptasticsoftware.rssreader.Enclosure;
import com.apptasticsoftware.rssreader.util.Default;
import com.apptasticsoftware.rssreader.util.ItemComparator;
import com.apptasticsoftware.rssreader.util.Mapper;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Item
implements Comparable<Item> {
    private final Comparator<Item> defaultComparator;
    private String title;
    private String description;
    private String content;
    private String link;
    private String author;
    private String category;
    private List<String> categories;
    private String guid;
    private Boolean isPermaLink;
    private String pubDate;
    private String updated;
    private String comments;
    private Enclosure enclosure;
    private List<Enclosure> enclosures;
    private Channel channel;
    private final DateTimeParser dateTimeParser;

    @Deprecated(since="3.5.0", forRemoval=true)
    public Item() {
        this.dateTimeParser = Default.getDateTimeParser();
        this.defaultComparator = ItemComparator.newestPublishedItemFirst();
    }

    public Item(DateTimeParser dateTimeParser) {
        this.dateTimeParser = dateTimeParser;
        this.defaultComparator = ItemComparator.newestPublishedItemFirst(dateTimeParser);
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description).or(this::getContent);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Optional<String> getContent() {
        return Optional.ofNullable(this.content);
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Optional<String> getLink() {
        return Optional.ofNullable(this.link);
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Optional<String> getAuthor() {
        return Optional.ofNullable(this.author);
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Deprecated(since="3.3.0", forRemoval=true)
    public Optional<String> getCategory() {
        return Optional.ofNullable(this.category);
    }

    @Deprecated(since="3.3.0", forRemoval=true)
    public void setCategory(String category) {
        this.category = category;
    }

    public List<String> getCategories() {
        return Mapper.emptyListIfNull(this.categories);
    }

    public void addCategory(String category) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.category = category;
        this.categories.add(category);
    }

    public Optional<String> getGuid() {
        return Optional.ofNullable(this.guid);
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public Optional<Boolean> getIsPermaLink() {
        return Optional.ofNullable(this.isPermaLink);
    }

    public void setIsPermaLink(boolean isPermaLink) {
        this.isPermaLink = isPermaLink;
    }

    public Optional<String> getPubDate() {
        return Optional.ofNullable(this.pubDate);
    }

    public void setPubDate(String pubDate) {
        this.pubDate = pubDate;
    }

    public Optional<ZonedDateTime> getPubDateAsZonedDateTime() {
        return this.getPubDate().map(this.dateTimeParser::parse);
    }

    @Deprecated(since="3.12.0", forRemoval=true)
    public Optional<ZonedDateTime> getPubDateZonedDateTime() {
        return this.getPubDateAsZonedDateTime();
    }

    public Optional<String> getUpdated() {
        return Optional.ofNullable(this.updated);
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public Optional<ZonedDateTime> getUpdatedAsZonedDateTime() {
        return this.getUpdated().map(this.dateTimeParser::parse);
    }

    @Deprecated(since="3.12.0", forRemoval=true)
    public Optional<ZonedDateTime> getUpdatedZonedDateTime() {
        return this.getUpdatedAsZonedDateTime();
    }

    public Optional<String> getComments() {
        return Optional.ofNullable(this.comments);
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Optional<Enclosure> getEnclosure() {
        return Optional.ofNullable(this.enclosure);
    }

    public void setEnclosure(Enclosure enclosure) {
        this.addEnclosure(enclosure);
    }

    public List<Enclosure> getEnclosures() {
        return Mapper.emptyListIfNull(this.enclosures);
    }

    public void addEnclosure(Enclosure enclosure) {
        if (this.enclosures == null) {
            this.enclosures = new ArrayList<Enclosure>();
        }
        this.enclosure = enclosure;
        this.enclosures.add(enclosure);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.getTitle(), item.getTitle()) && Objects.equals(this.getDescription(), item.getDescription()) && Objects.equals(this.getContent(), item.getContent()) && Objects.equals(this.getLink(), item.getLink()) && Objects.equals(this.getAuthor(), item.getAuthor()) && this.getCategories().equals(item.getCategories()) && Objects.equals(this.getGuid(), item.getGuid()) && Objects.equals(this.getIsPermaLink(), item.getIsPermaLink()) && Objects.equals(this.getPubDate(), item.getPubDate()) && Objects.equals(this.getUpdated(), item.getUpdated()) && Objects.equals(this.getComments(), item.getComments()) && this.getEnclosures().equals(item.getEnclosures()) && Objects.equals(this.getChannel(), item.getChannel());
    }

    public int hashCode() {
        return Objects.hash(this.getTitle(), this.getDescription(), this.getContent(), this.getLink(), this.getAuthor(), this.getCategories(), this.getGuid(), this.getIsPermaLink(), this.getPubDate(), this.getUpdated(), this.getComments(), this.getEnclosures(), this.getChannel());
    }

    @Override
    public int compareTo(Item o) {
        return this.defaultComparator.compare(this, o);
    }
}

