/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader.module.itunes;

import com.apptasticsoftware.rssreader.DateTimeParser;
import com.apptasticsoftware.rssreader.Item;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class ItunesItem
extends Item {
    private String itunesDuration;
    private String itunesImage;
    private boolean itunesExplicit;
    private String itunesTitle;
    private String itunesSubtitle;
    private String itunesSummary;
    private String itunesKeywords;
    private Integer itunesEpisode;
    private Integer itunesSeason;
    private String itunesEpisodeType;
    private boolean itunesBlock;

    public ItunesItem(DateTimeParser dateTimeParser) {
        super(dateTimeParser);
    }

    public Optional<String> getItunesDuration() {
        return Optional.ofNullable(this.itunesDuration);
    }

    public void setItunesDuration(String itunesDuration) {
        this.itunesDuration = itunesDuration;
    }

    public Optional<Duration> getItunesDurationAsDuration() {
        if (this.itunesDuration != null && !this.itunesDuration.isBlank()) {
            try {
                String[] parts = this.itunesDuration.split(":");
                if (parts.length == 1) {
                    return Optional.of(Duration.ofSeconds(Long.parseLong(parts[0])));
                }
                if (parts.length == 2) {
                    return Optional.of(Duration.ofMinutes(Long.parseLong(parts[0])).plusSeconds(Long.parseLong(parts[1])));
                }
                if (parts.length == 3) {
                    return Optional.of(Duration.ofHours(Long.parseLong(parts[0])).plusMinutes(Long.parseLong(parts[1])).plusSeconds(Long.parseLong(parts[2])));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public Optional<String> getItunesImage() {
        return Optional.ofNullable(this.itunesImage);
    }

    public void setItunesImage(String itunesImage) {
        this.itunesImage = itunesImage;
    }

    public boolean isItunesExplicit() {
        return this.itunesExplicit;
    }

    public void setItunesExplicit(boolean itunesExplicit) {
        this.itunesExplicit = itunesExplicit;
    }

    public Optional<String> getItunesTitle() {
        return Optional.ofNullable(this.itunesTitle);
    }

    public void setItunesTitle(String itunesTitle) {
        this.itunesTitle = itunesTitle;
    }

    public Optional<String> getItunesSubtitle() {
        return Optional.ofNullable(this.itunesSubtitle);
    }

    public void setItunesSubtitle(String itunesSubtitle) {
        this.itunesSubtitle = itunesSubtitle;
    }

    public Optional<String> getItunesSummary() {
        return Optional.ofNullable(this.itunesSummary);
    }

    public void setItunesSummary(String itunesSummary) {
        this.itunesSummary = itunesSummary;
    }

    public Optional<String> getItunesKeywords() {
        return Optional.ofNullable(this.itunesKeywords);
    }

    public void setItunesKeywords(String itunesKeywords) {
        this.itunesKeywords = itunesKeywords;
    }

    public Optional<Integer> getItunesEpisode() {
        return Optional.ofNullable(this.itunesEpisode);
    }

    public void setItunesEpisode(Integer itunesEpisode) {
        this.itunesEpisode = itunesEpisode;
    }

    public Optional<Integer> getItunesSeason() {
        return Optional.ofNullable(this.itunesSeason);
    }

    public void setItunesSeason(Integer itunesSeason) {
        this.itunesSeason = itunesSeason;
    }

    public Optional<String> getItunesEpisodeType() {
        return Optional.ofNullable(this.itunesEpisodeType);
    }

    public void setItunesEpisodeType(String itunesEpisodeType) {
        this.itunesEpisodeType = itunesEpisodeType;
    }

    public boolean isItunesBlock() {
        return this.itunesBlock;
    }

    public void setItunesBlock(boolean itunesBlock) {
        this.itunesBlock = itunesBlock;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ItunesItem that = (ItunesItem)o;
        return this.isItunesExplicit() == that.isItunesExplicit() && this.isItunesBlock() == that.isItunesBlock() && Objects.equals(this.getItunesDuration(), that.getItunesDuration()) && Objects.equals(this.getItunesImage(), that.getItunesImage()) && Objects.equals(this.getItunesTitle(), that.getItunesTitle()) && Objects.equals(this.getItunesSubtitle(), that.getItunesSubtitle()) && Objects.equals(this.getItunesSummary(), that.getItunesSummary()) && Objects.equals(this.getItunesKeywords(), that.getItunesKeywords()) && Objects.equals(this.getItunesEpisode(), that.getItunesEpisode()) && Objects.equals(this.getItunesSeason(), that.getItunesSeason()) && Objects.equals(this.getItunesEpisodeType(), that.getItunesEpisodeType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getItunesDuration(), this.getItunesImage(), this.isItunesExplicit(), this.getItunesTitle(), this.getItunesSubtitle(), this.getItunesSummary(), this.getItunesKeywords(), this.getItunesEpisode(), this.getItunesSeason(), this.getItunesEpisodeType(), this.isItunesBlock());
    }
}

