/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.framing;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.framing.Frame;
import com.apicatalog.jsonld.framing.FramingState;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.ListObject;
import com.apicatalog.jsonld.lang.NodeObject;
import com.apicatalog.jsonld.lang.ValueObject;
import jakarta.json.JsonArray;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class FrameMatcher {
    private FramingState state;
    private Frame frame;
    private boolean requireAll;

    private FrameMatcher(FramingState state, Frame frame, boolean requireAll) {
        this.state = state;
        this.frame = frame;
        this.requireAll = requireAll;
    }

    public static final FrameMatcher with(FramingState state, Frame frame, boolean requireAll) {
        return new FrameMatcher(state, frame, requireAll);
    }

    public List<String> match(Collection<String> subjects) throws JsonLdError {
        if (this.frame.isWildCard()) {
            return new ArrayList<String>(subjects);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String subject : subjects) {
            if (!this.match(this.state.getGraphMap().get(this.state.getGraphName(), subject))) continue;
            result.add(subject);
        }
        return result;
    }

    public boolean match(Map<String, JsonValue> node) throws JsonLdError {
        int count = 0;
        boolean nonKeywordProperty = false;
        for (String property : this.frame.keys()) {
            JsonArray nodeValues;
            JsonValue nodeValue;
            block43: {
                block45: {
                    block44: {
                        nodeValue = node.get(property);
                        if ("@id".equals(property)) {
                            nodeValue = JsonUtils.toJsonArray(nodeValue);
                            if (JsonUtils.toStream(this.frame.get(property)).anyMatch(arg_0 -> nodeValue.asJsonArray().contains(arg_0)) || this.frame.isWildCard("@id") || this.frame.isNone("@id")) {
                                if (this.requireAll) {
                                    ++count;
                                    continue;
                                }
                                return true;
                            }
                            return false;
                        }
                        if (!"@type".equals(property)) break block43;
                        if (JsonUtils.isNotNull(nodeValue) && !nodeValue.asJsonArray().isEmpty() && this.frame.isWildCard(property) || (JsonUtils.isNull(nodeValue) || nodeValue.asJsonArray().isEmpty()) && this.frame.isNone(property) || this.frame.isDefaultObject(property)) break block44;
                        if (!JsonUtils.isNotNull(nodeValue)) break block45;
                        if (!this.frame.getCollection(property).stream().anyMatch(arg_0 -> nodeValue.asJsonArray().contains(arg_0))) break block45;
                    }
                    if (this.requireAll) {
                        ++count;
                        continue;
                    }
                    return true;
                }
                return false;
            }
            if (Keywords.matchForm(property)) continue;
            nonKeywordProperty = true;
            JsonValue propertyValue = this.frame.get(property);
            Frame propertyFrame = JsonUtils.isNotNull(propertyValue) && JsonUtils.isNonEmptyArray(propertyValue) ? Frame.of((JsonStructure)propertyValue) : null;
            JsonArray jsonArray = nodeValues = nodeValue != null ? JsonUtils.toJsonArray(nodeValue) : JsonValue.EMPTY_JSON_ARRAY;
            if (nodeValues.isEmpty() && propertyFrame != null && propertyFrame.containsOnly("@default")) continue;
            if (nodeValues.isEmpty() && this.frame.isNone(property)) {
                if (this.requireAll) {
                    ++count;
                    continue;
                }
                return true;
            }
            if (!nodeValues.isEmpty() && this.frame.isNone(property)) {
                return false;
            }
            if (!nodeValues.isEmpty() && propertyFrame != null && propertyFrame.isWildCard()) {
                if (this.requireAll) {
                    ++count;
                    continue;
                }
                return true;
            }
            if (propertyFrame == null) {
                if (nodeValues.isEmpty()) {
                    if (this.requireAll) {
                        ++count;
                        continue;
                    }
                    return true;
                }
            } else if (propertyFrame.isListObject()) {
                JsonValue listValue = propertyFrame.get("@list");
                if (!nodeValues.isEmpty() && ListObject.isListObject((JsonValue)nodeValues.get(0))) {
                    JsonValue nodeListValue = (JsonValue)((JsonValue)nodeValues.get(0)).asJsonObject().get((Object)"@list");
                    if (ValueObject.isValueObject((JsonValue)listValue.asJsonArray().get(0))) {
                        boolean match = false;
                        for (JsonValue value : JsonUtils.toCollection(nodeListValue)) {
                            match = Frame.of((JsonStructure)listValue).matchValue(value);
                            if (!match) continue;
                            break;
                        }
                        if (match) {
                            if (this.requireAll) {
                                ++count;
                                continue;
                            }
                            return true;
                        }
                    } else if (NodeObject.isNodeObject((JsonValue)listValue.asJsonArray().get(0)) || NodeObject.isNodeReference((JsonValue)listValue.asJsonArray().get(0))) {
                        boolean match = false;
                        for (JsonValue value : JsonUtils.toCollection(nodeListValue)) {
                            match = Frame.of((JsonStructure)listValue).matchNode(this.state, value, this.requireAll);
                            if (!match) continue;
                            break;
                        }
                        if (match) {
                            if (this.requireAll) {
                                ++count;
                                continue;
                            }
                            return true;
                        }
                    }
                }
            } else if (propertyFrame.isValuePattern()) {
                if (nodeValues.stream().anyMatch(propertyFrame::matchValue)) {
                    if (this.requireAll) {
                        ++count;
                        continue;
                    }
                    return true;
                }
            } else if (propertyFrame.isNodeReference()) {
                boolean match = false;
                if (!nodeValues.isEmpty()) {
                    JsonValue values;
                    Iterator iterator = nodeValues.iterator();
                    while (iterator.hasNext() && !(match = propertyFrame.matchNode(this.state, values = (JsonValue)iterator.next(), this.requireAll))) {
                    }
                }
                if (match) {
                    if (this.requireAll) {
                        ++count;
                        continue;
                    }
                    return true;
                }
            } else if (!nodeValues.isEmpty()) {
                if (this.requireAll) {
                    ++count;
                    continue;
                }
                return true;
            }
            if (!this.requireAll) continue;
            return false;
        }
        return !nonKeywordProperty || count > 0;
    }
}

