/*
 * Decompiled with CFR 0.152.
 */
package com.anji.captcha.config;

import com.anji.captcha.model.common.ResponseModel;
import java.util.Objects;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Aspect
@ControllerAdvice
@Component
@ConditionalOnProperty(value={"aj.captcha.i18n.enabled"}, matchIfMissing=false)
public class I18nAspect
implements ResponseBodyAdvice<Object> {
    @Autowired(required=false)
    private MessageSource messageSource;
    @Value(value="${aj.captcha.i18n.prefix:aj.captcha.}")
    private String prefix;
    @Autowired
    private ApplicationContext applicationContext;

    public I18nAspect() {
        System.out.println("===>I18nAspect init...");
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return returnType.getParameterType().isAssignableFrom(ResponseModel.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof ResponseModel) {
            ResponseModel res = (ResponseModel)body;
            String code = res.getRepCode();
            String desc = this.getMessage(code, res);
            res.setRepMsg(desc);
            return res;
        }
        return body;
    }

    private String getMessage(String code, ResponseModel res) {
        try {
            if (Objects.isNull(this.messageSource)) {
                this.messageSource = (MessageSource)this.applicationContext.getBean(MessageSource.class);
            }
            return this.messageSource.getMessage(this.prefix + code, null, LocaleContextHolder.getLocale());
        }
        catch (Exception e) {
            return res.getRepMsg();
        }
    }
}

