/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.BuildTypeContainer;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.detector.api.TypeEvaluator;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ObjectAnimatorDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final String KEEP_ANNOTATION = "android.support.annotation.Keep";
    private static final Implementation IMPLEMENTATION = new Implementation(ObjectAnimatorDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue MISSING_KEEP = Issue.create((String)"AnimatorKeep", (String)"Missing @Keep for Animated Properties", (String)"When you use property animators, properties can be accessed via reflection. Those methods should be annotated with @Keep to ensure that during release builds, the methods are not potentially treated as unused and removed, or treated as internal only and get renamed to something shorter.\n\nThis check will also flag other potential reflection problems it encounters, such as a missing property, wrong argument types, etc.", (Category)Category.PERFORMANCE, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue BROKEN_PROPERTY = Issue.create((String)"ObjectAnimatorBinding", (String)"Incorrect ObjectAnimator Property", (String)"This check cross references properties referenced by String from `ObjectAnimator` and `PropertyValuesHolder` method calls and ensures that the corresponding setter methods exist and have the right signatures.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    private Set<PsiElement> mAlreadyWarned;

    public List<String> getApplicableMethodNames() {
        return Arrays.asList("ofInt", "ofArgb", "ofFloat", "ofMultiInt", "ofMultiFloat", "ofObject", "ofPropertyValuesHolder");
    }

    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression call, PsiMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (!(evaluator.isMemberInClass((PsiMember)method, "android.animation.ObjectAnimator") || method.getName().equals("ofPropertyValuesHolder") && evaluator.isMemberInClass((PsiMember)method, "android.animation.ValueAnimator"))) {
            return;
        }
        PsiExpression[] expressions = call.getArgumentList().getExpressions();
        if (expressions.length < 2) {
            return;
        }
        PsiType type = TypeEvaluator.evaluate((JavaContext)context, (PsiElement)expressions[0]);
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClass targetClass = ((PsiClassType)type).resolve();
        if (targetClass == null) {
            return;
        }
        String methodName = method.getName();
        if (methodName.equals("ofPropertyValuesHolder")) {
            if (!evaluator.isMemberInClass((PsiMember)method, "android.animation.ObjectAnimator")) {
                return;
            }
            this.checkPropertyValueHolders(context, targetClass, expressions);
        } else {
            String expectedType = ObjectAnimatorDetector.getExpectedType(context, call, 2);
            if (expectedType != null) {
                this.checkProperty(context, expressions[1], targetClass, expectedType);
            }
        }
    }

    private static String getExpectedType(JavaContext context, PsiMethodCallExpression method, int evaluatorIndex) {
        String methodName = method.getMethodExpression().getReferenceName();
        if (methodName == null) {
            return null;
        }
        switch (methodName) {
            case "ofArgb": 
            case "ofInt": {
                return "int";
            }
            case "ofFloat": {
                return "float";
            }
            case "ofMultiInt": {
                return "int[]";
            }
            case "ofMultiFloat": {
                return "float[]";
            }
            case "ofKeyframe": {
                return "android.animation.Keyframe";
            }
            case "ofObject": {
                PsiType evaluatorType;
                PsiExpression[] args = method.getArgumentList().getExpressions();
                if (args.length <= evaluatorIndex || (evaluatorType = TypeEvaluator.evaluate((JavaContext)context, (PsiElement)args[evaluatorIndex])) == null) break;
                String typeName = evaluatorType.getCanonicalText();
                if ("android.animation.FloatEvaluator".equals(typeName)) {
                    return "float";
                }
                if ("android.animation.FloatArrayEvaluator".equals(typeName)) {
                    return "float[]";
                }
                if ("android.animation.IntEvaluator".equals(typeName) || "android.animation.ArgbEvaluator".equals(typeName)) {
                    return "int";
                }
                if ("android.animation.IntArrayEvaluator".equals(typeName)) {
                    return "int[]";
                }
                if (!"android.animation.PointFEvaluator".equals(typeName)) break;
                return "android.graphics.PointF";
            }
        }
        return null;
    }

    private void checkPropertyValueHolders(JavaContext context, PsiClass targetClass, PsiExpression[] expressions) {
        for (int i = 1; i < expressions.length; ++i) {
            String expectedType;
            PsiExpression[] args;
            PsiExpression arg = expressions[i];
            PsiMethodCallExpression holder = ObjectAnimatorDetector.findHolderConstruction(context, arg);
            if (holder == null || (args = holder.getArgumentList().getExpressions()).length < 2 || (expectedType = ObjectAnimatorDetector.getExpectedType(context, holder, 1)) == null) continue;
            this.checkProperty(context, args[0], targetClass, expectedType);
        }
    }

    private static PsiMethodCallExpression findHolderConstruction(JavaContext context, PsiExpression arg) {
        PsiElement resolved;
        if (arg == null) {
            return null;
        }
        if (arg instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)arg;
            if (ObjectAnimatorDetector.isHolderConstructionMethod(context, callExpression)) {
                return callExpression;
            }
        } else if (arg instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)arg).resolve()) instanceof PsiVariable) {
            PsiStatement statement;
            PsiMethodCallExpression holder;
            PsiVariable variable = (PsiVariable)resolved;
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && (holder = ObjectAnimatorDetector.findHolderConstruction(context, initializer)) != null) {
                return holder;
            }
            if (!(variable instanceof PsiField) && (statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)arg, PsiStatement.class, (boolean)false)) != null) {
                PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                String targetName = variable.getName();
                if (targetName == null) {
                    return null;
                }
                while (prev != null) {
                    PsiReferenceExpression reference;
                    PsiAssignmentExpression assign;
                    PsiExpression lhs;
                    PsiExpression expression;
                    if (prev instanceof PsiDeclarationStatement) {
                        for (PsiElement element : ((PsiDeclarationStatement)prev).getDeclaredElements()) {
                            if (!variable.equals(element)) continue;
                            return ObjectAnimatorDetector.findHolderConstruction(context, variable.getInitializer());
                        }
                    } else if (prev instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                        return ObjectAnimatorDetector.findHolderConstruction(context, assign.getRExpression());
                    }
                    prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                }
            }
        }
        return null;
    }

    private static boolean isHolderConstructionMethod(JavaContext context, PsiMethodCallExpression callExpression) {
        PsiMethod resolved;
        String referenceName = callExpression.getMethodExpression().getReferenceName();
        return referenceName != null && referenceName.startsWith("of") && (resolved = callExpression.resolveMethod()) != null && context.getEvaluator().isMemberInClass((PsiMember)resolved, "android.animation.PropertyValuesHolder");
    }

    private void checkProperty(JavaContext context, PsiExpression propertyNameExpression, PsiClass targetClass, String expectedType) {
        Object property = ConstantEvaluator.evaluate((JavaContext)context, (PsiElement)propertyNameExpression);
        if (!(property instanceof String)) {
            return;
        }
        String propertyName = (String)property;
        String qualifiedName = targetClass.getQualifiedName();
        if (qualifiedName == null || qualifiedName.indexOf(46) == -1) {
            return;
        }
        String methodName = ObjectAnimatorDetector.getMethodName("set", propertyName);
        PsiMethod[] methods = targetClass.findMethodsByName(methodName, true);
        PsiMethod bestMethod = null;
        boolean isExactMatch = false;
        for (PsiMethod m : methods) {
            if (m.getParameterList().getParametersCount() == 1) {
                if (bestMethod == null) {
                    bestMethod = m;
                }
                if (!context.getEvaluator().parametersMatch(m, new String[]{expectedType})) continue;
                bestMethod = m;
                isExactMatch = true;
                break;
            }
            if (bestMethod != null) continue;
            bestMethod = m;
        }
        if (bestMethod == null) {
            this.report(context, BROKEN_PROPERTY, propertyNameExpression, null, String.format("Could not find property setter method `%1$s` on `%2$s`", methodName, qualifiedName));
            return;
        }
        if (!isExactMatch) {
            this.report(context, BROKEN_PROPERTY, propertyNameExpression, bestMethod, String.format("The setter for this property does not match the expected signature (`public void %1$s(%2$s arg`)", methodName, expectedType));
        } else if (context.getEvaluator().isStatic(bestMethod)) {
            this.report(context, BROKEN_PROPERTY, propertyNameExpression, bestMethod, String.format("The setter for this property (%1$s.%2$s) should not be static", qualifiedName, methodName));
        } else {
            PsiMethod owner = bestMethod;
            while (owner != null) {
                PsiModifierList modifierList = owner.getModifierList();
                if (modifierList != null) {
                    for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                        if (!KEEP_ANNOTATION.equals(annotation.getQualifiedName())) continue;
                        return;
                    }
                }
                owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiModifierListOwner.class, (boolean)true);
            }
            if (!ObjectAnimatorDetector.isMinifying(context)) {
                return;
            }
            this.report(context, MISSING_KEEP, propertyNameExpression, bestMethod, "This method is accessed from an ObjectAnimator so it should be annotated with `@Keep` to ensure that it is not discarded or renamed in release builds");
        }
    }

    private void report(JavaContext context, Issue issue, PsiExpression propertyNameExpression, PsiMethod method, String message) {
        Location location;
        PsiMethod locationNode;
        boolean reportOnMethod;
        boolean bl = reportOnMethod = issue == MISSING_KEEP && method != null;
        if (reportOnMethod && method instanceof PsiCompiledElement) {
            return;
        }
        Object object = locationNode = reportOnMethod ? method : propertyNameExpression;
        if (this.mAlreadyWarned != null && this.mAlreadyWarned.contains(locationNode)) {
            return;
        }
        if (this.mAlreadyWarned == null) {
            this.mAlreadyWarned = Sets.newIdentityHashSet();
        }
        this.mAlreadyWarned.add((PsiElement)locationNode);
        Location methodLocation = null;
        if (method != null) {
            methodLocation = method.getNameIdentifier() != null ? context.getRangeLocation((PsiElement)method.getNameIdentifier(), 0, (PsiElement)method.getParameterList(), 0) : context.getNameLocation((PsiElement)method);
        }
        Location location2 = location = reportOnMethod ? methodLocation : context.getNameLocation((PsiElement)locationNode);
        if (reportOnMethod) {
            Location secondary = context.getLocation((PsiElement)propertyNameExpression);
            location.setSecondary(secondary);
            secondary.setMessage("ObjectAnimator usage here");
            if (Objects.equals(propertyNameExpression.getContainingFile(), method.getContainingFile())) {
                secondary.setVisible(false);
            } else {
                assert (issue == MISSING_KEEP);
                String secondaryMessage = String.format("The method referenced here (%1$s) has not been annotated with `@Keep` which means it could be discarded or renamed in release builds", method.getName());
                if (location == Location.NONE) {
                    location = secondary;
                    message = secondaryMessage;
                } else {
                    secondary.setMessage(secondaryMessage);
                }
            }
        } else if (methodLocation != null) {
            location = location.withSecondary(methodLocation, "Property setter here");
        }
        context.report(issue, (PsiElement)method, location, message);
    }

    public static boolean isAddKeepErrorMessage(String message, TextFormat textFormat) {
        message = textFormat.convertTo(message, TextFormat.RAW);
        return message.contains("This method is accessed from an ObjectAnimator so");
    }

    private static String getMethodName(String prefix, String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return prefix;
        }
        char firstLetter = Character.toUpperCase(propertyName.charAt(0));
        String theRest = propertyName.substring(1);
        return prefix + firstLetter + theRest;
    }

    private static boolean isMinifying(JavaContext context) {
        Project project = context.getMainProject();
        if (!project.isGradleProject()) {
            return true;
        }
        AndroidProject model = project.getGradleProjectModel();
        if (model != null) {
            for (BuildTypeContainer buildTypeContainer : model.getBuildTypes()) {
                if (!buildTypeContainer.getBuildType().isMinifyEnabled()) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

