/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class FirebaseMessagingDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final String FIREBASE_IID_PACKAGE = "com.google.firebase.iid";
    private static final String FIREBASE_IID_CLASS_NAME = "com.google.firebase.iid.FirebaseInstanceId";
    private static final String FIREBASE_IID_SERVICE_CLASS_NAME = "com.google.firebase.iid.FirebaseInstanceIdService";
    private static final String ON_TOKEN_REFRESH_METHOD_NAME = "onTokenRefresh";
    private static final String GET_TOKEN_METHOD_NAME = "getToken";
    private static final Implementation IMPLEMENTATION = new Implementation(FirebaseMessagingDetector.class, Scope.JAVA_FILE_SCOPE, new EnumSet[]{Scope.ALL});
    public static final Issue MISSING_TOKEN_REFRESH = Issue.create((String)"MissingFirebaseInstanceTokenRefresh", (String)"Missing Firebase Instance ID Token Refresh", (String)"Apps that check the Firebase Instance ID should usually implement the FirebaseInstanceIdService#onTokenRefresh() callback in order to observe changes.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("https://firebase.google.com/docs/cloud-messaging/android/client#monitor-token-generation");
    private boolean mIsOnTokenRefreshDefined;
    private PsiMethodCallExpression mGetTokenCallSite;
    private JavaContext mGetTokenContext;

    public void beforeCheckProject(Context context) {
        this.mIsOnTokenRefreshDefined = false;
        this.mGetTokenCallSite = null;
        this.mGetTokenContext = null;
    }

    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression call, PsiMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null && FIREBASE_IID_CLASS_NAME.equals(containingClass.getQualifiedName())) {
            this.mGetTokenCallSite = call;
            this.mGetTokenContext = context;
        }
    }

    public void checkClass(JavaContext context, PsiClass declaration) {
        if (!FIREBASE_IID_SERVICE_CLASS_NAME.equals(declaration.getQualifiedName())) {
            for (PsiMethod method : declaration.getMethods()) {
                if (!method.getName().equals(ON_TOKEN_REFRESH_METHOD_NAME)) continue;
                this.mIsOnTokenRefreshDefined = true;
            }
        }
    }

    public void afterCheckProject(Context context) {
        if (this.mGetTokenCallSite != null && !this.mIsOnTokenRefreshDefined) {
            context.report(MISSING_TOKEN_REFRESH, this.mGetTokenContext.getLocation((PsiElement)this.mGetTokenCallSite), "getToken() called without defining onTokenRefresh callback.");
        }
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(GET_TOKEN_METHOD_NAME);
    }

    public List<String> applicableSuperClasses() {
        return Collections.singletonList(FIREBASE_IID_SERVICE_CLASS_NAME);
    }
}

