/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ConstraintLayoutDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"MissingConstraints", (String)"Missing Constraints in ConstraintLayout", (String)"The layout editor allows you to place widgets anywhere on the canvas, and it records the current position with designtime attributes (such as `layout_editor_absoluteX`.) These attributes are *not* applied at runtime, so if you push your layout on a device, the widgets may appear in a different location than shown in the editor. To fix this, make sure a widget has both horizontal and vertical constraints by dragging from the edge connections.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(ConstraintLayoutDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private static final String LAYOUT_CONSTRAINT_PREFIX = "layout_constraint";
    public static final GradleCoordinate LATEST_KNOWN_VERSION = new GradleCoordinate("com.android.support.constraint", "constraint-layout", "1.0.0-beta3");

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("android.support.constraint.ConstraintLayout");
    }

    public void visitElement(XmlContext context, Element layout) {
        Variant variant = context.getMainProject().getCurrentVariant();
        GradleCoordinate latestAvailable = null;
        if (variant != null) {
            Dependencies dependencies = variant.getMainArtifact().getDependencies();
            for (AndroidLibrary library : dependencies.getLibraries()) {
                GradleCoordinate version;
                MavenCoordinates rc = library.getResolvedCoordinates();
                if (!"com.android.support.constraint".equals(rc.getGroupId()) || !"constraint-layout".equals(rc.getArtifactId())) continue;
                if (latestAvailable == null) {
                    latestAvailable = ConstraintLayoutDetector.getLatestVersion(context);
                }
                if (GradleCoordinate.COMPARE_PLUS_LOWER.compare(latestAvailable, version = new GradleCoordinate("com.android.support.constraint", "constraint-layout", rc.getVersion())) <= 0) continue;
                String message = "Using version " + version.getRevision() + " of the constraint library, which is obsolete";
                context.report(GradleDetector.DEPENDENCY, (Node)layout, context.getLocation((Node)layout), message);
            }
        }
        for (Node child = layout.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element element;
            if (child.getNodeType() != 1 || (element = (Element)child).getTagName().equals("android.support.constraint.Guideline")) continue;
            boolean isConstrainedHorizontally = false;
            boolean isConstrainedVertically = false;
            if (!element.hasAttributeNS("http://schemas.android.com/tools", "layout_editor_absoluteX")) {
                isConstrainedHorizontally = true;
            }
            if (!element.hasAttributeNS("http://schemas.android.com/tools", "layout_editor_absoluteY")) {
                isConstrainedVertically = true;
                if (isConstrainedHorizontally) continue;
            }
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                String name = attribute.getLocalName();
                if (name == null || !name.startsWith(LAYOUT_CONSTRAINT_PREFIX) || name.endsWith("_creator")) continue;
                if (name.endsWith("toLeftOf") || name.endsWith("toRightOf") || name.endsWith("toStartOf") || name.endsWith("toEndOf") || name.endsWith("toCenterX")) {
                    isConstrainedHorizontally = true;
                    if (!isConstrainedVertically) continue;
                    break;
                }
                if (!name.endsWith("toTopOf") && !name.endsWith("toBottomOf") && !name.endsWith("toCenterY") && !name.endsWith("toBaselineOf")) continue;
                isConstrainedVertically = true;
                if (isConstrainedHorizontally) break;
            }
            if (isConstrainedHorizontally && isConstrainedVertically) continue;
            String message = isConstrainedVertically ? "This view is not constrained horizontally: at runtime it will jump to the left unless you add a horizontal constraint" : (isConstrainedHorizontally ? "This view is not constrained vertically: at runtime it will jump to the left unless you add a vertical constraint" : "This view is not constrained, it only has designtime positions, so it will jump to (0,0) unless you add constraints");
            context.report(ISSUE, (Node)element, context.getLocation((Node)element), message);
        }
    }

    private static GradleCoordinate getLatestVersion(XmlContext context) {
        GradleCoordinate fromPackage;
        ProgressIndicator progress;
        RepoPackage latestPackage;
        GradleCoordinate latestAvailable = LATEST_KNOWN_VERSION;
        AndroidSdkHandler sdkHandler = context.getClient().getSdk();
        if (sdkHandler != null && (latestPackage = SdkMavenRepository.findLatestVersion((GradleCoordinate)LATEST_KNOWN_VERSION, (AndroidSdkHandler)sdkHandler, (ProgressIndicator)(progress = context.getClient().getRepositoryLogger()))) != null && (fromPackage = SdkMavenRepository.getCoordinateFromSdkPath((String)latestPackage.getPath())) != null && GradleCoordinate.COMPARE_PLUS_LOWER.compare(latestAvailable, fromPackage) < 0) {
            latestAvailable = fromPackage;
        }
        return latestAvailable;
    }

    public static boolean isUpgradeDependencyError(String errorMessage, TextFormat format) {
        errorMessage = format.convertTo(errorMessage, TextFormat.RAW);
        return errorMessage.contains(" of the constraint library, which is obsolete");
    }
}

