/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.google.common.annotations.Beta;

@Beta
public final class Category
implements Comparable<Category> {
    private final String name;
    private final int priority;
    private final Category parent;
    public static final Category LINT = Category.create("Lint", 110);
    public static final Category CORRECTNESS = Category.create("Correctness", 100);
    public static final Category SECURITY = Category.create("Security", 90);
    public static final Category PERFORMANCE = Category.create("Performance", 80);
    public static final Category USABILITY = Category.create("Usability", 70);
    public static final Category A11Y = Category.create("Accessibility", 60);
    public static final Category I18N = Category.create("Internationalization", 50);
    public static final Category ICONS = Category.create(USABILITY, "Icons", 73);
    public static final Category TYPOGRAPHY = Category.create(USABILITY, "Typography", 76);
    public static final Category MESSAGES = Category.create(CORRECTNESS, "Messages", 95);
    public static final Category CHROME_OS = Category.create(CORRECTNESS, "Chrome OS", 93);
    public static final Category RTL = Category.create(I18N, "Bidirectional Text", 40);

    private Category(Category parent, String name, int priority) {
        this.parent = parent;
        this.name = name;
        this.priority = priority;
    }

    public static Category create(String name, int priority) {
        return new Category(null, name, priority);
    }

    public static Category create(Category parent, String name, int priority) {
        return new Category(parent, name, priority);
    }

    public Category getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.parent != null) {
            return this.parent.getFullName() + ':' + this.name;
        }
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Category category = (Category)o;
        if (!this.name.equals(category.name)) {
            return false;
        }
        return this.parent != null ? this.parent.equals(category.parent) : category.parent == null;
    }

    public String toString() {
        return this.getFullName();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Category other) {
        int delta;
        if (other.priority == this.priority) {
            if (this.parent == other) {
                return 1;
            }
            if (other.parent == this) {
                return -1;
            }
        }
        if ((delta = other.priority - this.priority) != 0) {
            return delta;
        }
        return this.name.compareTo(other.name);
    }
}

