/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Identifier;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePartTemplate;

public class TypeReferencePart
extends AbstractNode {
    private AbstractNode identifier = this.adopt(new Identifier());
    ListAccessor<TypeReference, TypeReferencePart> typeArguments = ListAccessor.of(this, TypeReference.class, "TypeReferencePart.typeArguments");

    public TypeReference upToTypeReference() {
        if (!(this.getParent() instanceof TypeReference)) {
            return null;
        }
        TypeReference out = (TypeReference)this.getParent();
        if (!out.rawParts().contains(this)) {
            return null;
        }
        return out;
    }

    public Identifier astIdentifier() {
        if (!(this.identifier instanceof Identifier)) {
            return null;
        }
        return (Identifier)this.identifier;
    }

    public TypeReferencePart astIdentifier(Identifier identifier) {
        return this.rawIdentifier(identifier);
    }

    private TypeReferencePart rawIdentifier(Node identifier) {
        if (identifier == this.identifier) {
            return this;
        }
        if (identifier != null) {
            this.adopt((AbstractNode)identifier);
        }
        if (this.identifier != null) {
            this.disown(this.identifier);
        }
        this.identifier = (AbstractNode)identifier;
        return this;
    }

    public RawListAccessor<TypeReference, TypeReferencePart> rawTypeArguments() {
        return this.typeArguments.asRaw();
    }

    public StrictListAccessor<TypeReference, TypeReferencePart> astTypeArguments() {
        return this.typeArguments.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.identifier != null) {
            result.add(this.identifier);
        }
        result.addAll(this.typeArguments.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.identifier == original) {
            if (replacement instanceof Identifier) {
                this.astIdentifier((Identifier)replacement);
                return true;
            }
            throw new AstException(this, String.format("Cannot replace node: replacement must be of type %s but is of type %s", "Identifier", replacement == null ? "null" : replacement.getClass().getName()));
        }
        return this.rawTypeArguments().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        if (this.identifier == child) {
            this.disown((AbstractNode)child);
            this.identifier = null;
            return true;
        }
        return this.rawTypeArguments().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitTypeReferencePart(this)) {
            return;
        }
        if (this.identifier != null) {
            this.identifier.accept(visitor);
        }
        for (AbstractNode child : this.typeArguments.asIterable()) {
            child.accept(visitor);
        }
        visitor.afterVisitTypeReferencePart(this);
        visitor.endVisit(this);
    }

    @Override
    public TypeReferencePart copy() {
        TypeReferencePart result = new TypeReferencePart();
        if (this.identifier != null) {
            result.rawIdentifier(this.identifier.copy());
        }
        for (AbstractNode n : this.typeArguments.backingList()) {
            result.rawTypeArguments().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }

    public String getTypeName() {
        return TypeReferencePartTemplate.getTypeName(this);
    }
}

