/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.SystemProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class IOUtil {
    public static final boolean ourByteBuffersUseNativeByteOrder = SystemProperties.getBooleanProperty("idea.bytebuffers.use.native.byte.order", true);
    private static final ThreadLocalCachedValue<byte[]> ourReadWriteBuffersCache = new ThreadLocalCachedValue<byte[]>(){

        @Override
        protected byte[] create() {
            return IOUtil.allocReadWriteUTFBuffer();
        }
    };
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final ThreadLocalCachedValue<char[]> spareBufferLocal = new ThreadLocalCachedValue<char[]>(){

        @Override
        protected char[] create() {
            return new char[255];
        }
    };

    public static String readString(@NotNull DataInput stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/util/io/IOUtil", "readString"));
        }
        int length = stream.readInt();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length * 2];
        stream.readFully(bytes);
        return new String(bytes, 0, length * 2, CharsetToolkit.UTF_16BE_CHARSET);
    }

    public static void writeString(String s, @NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/util/io/IOUtil", "writeString"));
        }
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        stream.writeInt(s.length());
        if (s.isEmpty()) {
            return;
        }
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length * 2];
        int i = 0;
        int i2 = 0;
        while (i < chars.length) {
            char aChar = chars[i];
            bytes[i2] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i2 + 1] = (byte)(aChar & 0xFF);
            ++i;
            i2 += 2;
        }
        stream.write(bytes);
    }

    @NotNull
    public static byte[] allocReadWriteUTFBuffer() {
        byte[] byArray = new byte[256];
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/IOUtil", "allocReadWriteUTFBuffer"));
        }
        return byArray;
    }

    public static void writeUTFFast(@NotNull byte[] buffer, @NotNull DataOutput storage, @NotNull String value) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/io/IOUtil", "writeUTFFast"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/util/io/IOUtil", "writeUTFFast"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/io/IOUtil", "writeUTFFast"));
        }
        int len = value.length();
        if (len < 255) {
            buffer[0] = (byte)len;
            boolean isAscii = true;
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c >= '\u0080') {
                    isAscii = false;
                    break;
                }
                buffer[i + 1] = (byte)c;
            }
            if (isAscii) {
                storage.write(buffer, 0, len + 1);
                return;
            }
        }
        storage.writeByte(-1);
        try {
            storage.writeUTF(value);
        }
        catch (UTFDataFormatException e) {
            storage.writeUTF("LONGER_THAN_64K");
            IOUtil.writeString(value, storage);
        }
    }

    public static String readUTFFast(@NotNull byte[] buffer, @NotNull DataInput storage) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/io/IOUtil", "readUTFFast"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/util/io/IOUtil", "readUTFFast"));
        }
        int len = 0xFF & storage.readByte();
        if (len == 255) {
            String result = storage.readUTF();
            if ("LONGER_THAN_64K".equals(result)) {
                return IOUtil.readString(storage);
            }
            return result;
        }
        if (len == 0) {
            return "";
        }
        storage.readFully(buffer, 0, len);
        char[] chars = spareBufferLocal.getValue();
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(buffer[i] & 0xFF);
        }
        return new String(chars, 0, len);
    }
}

