/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

public class BloomFilterBase {
    private final int myHashFunctionCount;
    private final int myBitsCount;
    private final long[] myElementsSet;

    protected BloomFilterBase(int _maxElementCount, double probability) {
        int bitsPerElementFactor = (int)Math.ceil(-Math.log(probability) / (Math.log(2.0) * Math.log(2.0)));
        this.myHashFunctionCount = (int)Math.ceil((double)bitsPerElementFactor * Math.log(2.0));
        int bitsCount = _maxElementCount * bitsPerElementFactor;
        if ((bitsCount & 1) == 0) {
            ++bitsCount;
        }
        while (!BloomFilterBase.isPrime(bitsCount)) {
            bitsCount += 2;
        }
        this.myBitsCount = bitsCount;
        this.myElementsSet = new long[(bitsCount >> 6) + 1];
    }

    private static boolean isPrime(int bits) {
        if ((bits & 1) == 0 || bits % 3 == 0) {
            return false;
        }
        int sqrt = (int)Math.sqrt(bits);
        for (int i = 6; i <= sqrt; i += 6) {
            if (bits % (i - 1) != 0 && bits % (i + 1) != 0) continue;
            return false;
        }
        return true;
    }
}

