/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiRefElementCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiChildLink<Parent extends PsiElement, Child extends PsiElement>
implements PsiRefElementCreator<Parent, Child> {
    @Nullable
    public abstract Child findLinkedChild(@Nullable Parent var1);

    @NotNull
    public final PsiElementRef<Child> createChildRef(@NotNull Parent parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/PsiChildLink", "createChildRef"));
        }
        Child existing = this.findLinkedChild(parent);
        if (existing != null) {
            PsiElementRef<Child> psiElementRef = PsiElementRef.real(existing);
            if (psiElementRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiChildLink", "createChildRef"));
            }
            return psiElementRef;
        }
        PsiElementRef psiElementRef = PsiElementRef.imaginary(PsiElementRef.real(parent), this);
        if (psiElementRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiChildLink", "createChildRef"));
        }
        return psiElementRef;
    }

    @NotNull
    public final PsiElementRef<Child> createChildRef(@NotNull PsiElementRef<? extends Parent> parentRef) {
        Child existing;
        if (parentRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentRef", "com/intellij/psi/PsiChildLink", "createChildRef"));
        }
        Parent parent = parentRef.getPsiElement();
        if (parent != null && (existing = this.findLinkedChild(parent)) != null) {
            PsiElementRef<Child> psiElementRef = PsiElementRef.real(existing);
            if (psiElementRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiChildLink", "createChildRef"));
            }
            return psiElementRef;
        }
        PsiElementRef psiElementRef = PsiElementRef.imaginary(parentRef, this);
        if (psiElementRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiChildLink", "createChildRef"));
        }
        return psiElementRef;
    }
}

