/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.CommonBundle;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class PsiBundle {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    private static final String BUNDLE = "messages.PsiBundle";

    public static String message(@NotNull @PropertyKey(resourceBundle="messages.PsiBundle") String key, Object ... params) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/PsiBundle", "message"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/psi/PsiBundle", "message"));
        }
        return CommonBundle.message(PsiBundle.getBundle(), key, params);
    }

    private PsiBundle() {
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    @NotNull
    public static String visibilityPresentation(@NotNull String modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/psi/PsiBundle", "visibilityPresentation"));
        }
        String string = PsiBundle.message(modifier + ".visibility.presentation", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiBundle", "visibilityPresentation"));
        }
        return string;
    }
}

