/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.dependency.HashCodeUtils;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Pattern;

public class Symbol {
    private static final Pattern RESOURCE_TYPE_PATTERN = Pattern.compile("\\S+");
    private static final Pattern NAME_PATTERN = Pattern.compile("\\S+");
    private static final Pattern JAVA_TYPE_PATTERN = Pattern.compile("\\S+");
    private static final Pattern VALUE_PATTERN = Pattern.compile(".*\\S+.*");
    private final String name;
    private final String javaType;
    private final String value;
    private final String resourceType;

    public Symbol(String resourceType, String name, String javaType, String value) {
        Preconditions.checkArgument((boolean)RESOURCE_TYPE_PATTERN.matcher(resourceType).matches());
        Preconditions.checkArgument((boolean)NAME_PATTERN.matcher(name).matches());
        Preconditions.checkArgument((boolean)JAVA_TYPE_PATTERN.matcher(javaType).matches());
        Preconditions.checkArgument((boolean)VALUE_PATTERN.matcher(value).matches());
        this.resourceType = resourceType;
        this.name = name;
        this.javaType = javaType;
        this.value = value;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public int hashCode() {
        return HashCodeUtils.hashCode(this.resourceType, this.name, this.javaType, this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Symbol)) {
            return false;
        }
        Symbol other = (Symbol)obj;
        return Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.name, other.name) && Objects.equals(this.javaType, other.javaType) && Objects.equals(this.value, other.value);
    }
}

