/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.zip.utils;

import com.android.apkzlib.zip.utils.CloseableByteSource;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CloseableDelegateByteSource
extends CloseableByteSource {
    @Nullable
    private ByteSource mInner;
    private final long mSize;

    public CloseableDelegateByteSource(@Nonnull ByteSource inner, long size) {
        this.mInner = inner;
        this.mSize = size;
    }

    @Nonnull
    private synchronized ByteSource get() {
        if (this.mInner == null) {
            throw new ByteSourceDisposedException();
        }
        return this.mInner;
    }

    @Override
    protected synchronized void innerClose() throws IOException {
        if (this.mInner == null) {
            return;
        }
        this.mInner = null;
    }

    public long sizeNoException() {
        return this.mSize;
    }

    public CharSource asCharSource(Charset charset) {
        return this.get().asCharSource(charset);
    }

    public InputStream openBufferedStream() throws IOException {
        return this.get().openBufferedStream();
    }

    public ByteSource slice(long offset, long length) {
        return this.get().slice(offset, length);
    }

    public boolean isEmpty() throws IOException {
        return this.get().isEmpty();
    }

    public long size() throws IOException {
        return this.get().size();
    }

    public long copyTo(@Nonnull OutputStream output) throws IOException {
        return this.get().copyTo(output);
    }

    public long copyTo(@Nonnull ByteSink sink) throws IOException {
        return this.get().copyTo(sink);
    }

    public byte[] read() throws IOException {
        return this.get().read();
    }

    public <T> T read(@Nonnull ByteProcessor<T> processor) throws IOException {
        return (T)this.get().read(processor);
    }

    public HashCode hash(HashFunction hashFunction) throws IOException {
        return this.get().hash(hashFunction);
    }

    public boolean contentEquals(@Nonnull ByteSource other) throws IOException {
        return this.get().contentEquals(other);
    }

    public InputStream openStream() throws IOException {
        return this.get().openStream();
    }

    private static class ByteSourceDisposedException
    extends RuntimeException {
        private ByteSourceDisposedException() {
            super("Byte source was created by a ByteTracker and is now disposed. If you see this message, then there is a bug.");
        }
    }
}

