/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.sign;

import com.android.apkzlib.sign.DigestAlgorithm;
import com.android.apkzlib.sign.ManifestGenerationExtension;
import com.android.apkzlib.sign.SignatureAlgorithm;
import com.android.apkzlib.utils.IOExceptionRunnable;
import com.android.apkzlib.zip.StoredEntry;
import com.android.apkzlib.zip.ZFileExtension;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public class SignatureExtension {
    private static final String SIGNATURE_BASE = "META-INF/CERT";
    private static final String SIGNATURE_FILE = "META-INF/CERT.SF";
    private static final String SIGNATURE_VERSION_NAME = "Signature-Version";
    private static final String SIGNATURE_VERSION_VALUE = "1.0";
    private static final String SIGNATURE_CREATED_BY_NAME = "Created-By";
    private static final String SIGNATURE_CREATED_BY_VALUE = "1.0 (Android)";
    private static final String SIGNATURE_ANDROID_APK_SIGNED_NAME = "X-Android-APK-Signed";
    public static final String SIGNATURE_ANDROID_APK_SIGNER_VALUE_WHEN_V2_SIGNED = "2";
    private static final Set<String> IGNORED_FILES = Sets.newHashSet((Object[])new String[]{"META-INF/MANIFEST.MF", "META-INF/CERT.SF"});
    private static final Set<String> IGNORED_FILES_LC = Sets.newHashSet((Iterable)IGNORED_FILES.stream().map(i -> i.toLowerCase(Locale.US)).collect(Collectors.toSet()));
    private static final Set<String> IGNORED_PREFIXES = Sets.newHashSet((Object[])new String[]{"SIG-"});
    private static final Set<String> IGNORED_PREFIXES_LC = Sets.newHashSet((Iterable)IGNORED_PREFIXES.stream().map(i -> i.toLowerCase(Locale.US)).collect(Collectors.toSet()));
    private static final Set<String> IGNORED_SUFFIXES = Sets.newHashSet((Object[])new String[]{".SF", ".DSA", ".RSA", ".EC"});
    private static final Set<String> IGNORED_SUFFIXES_LC = Sets.newHashSet((Iterable)IGNORED_SUFFIXES.stream().map(i -> i.toLowerCase(Locale.US)).collect(Collectors.toSet()));
    @Nonnull
    private final ManifestGenerationExtension mManifestExtension;
    @Nonnull
    private final MessageDigest mMessageDigest;
    @Nonnull
    private final Manifest mSignatureFile;
    private boolean mDirty;
    @Nonnull
    private final X509Certificate mCertificate;
    @Nonnull
    private final PrivateKey mPrivateKey;
    @Nonnull
    private final SignatureAlgorithm mSignatureAlgorithm;
    @Nonnull
    private final DigestAlgorithm mDigestAlgorithm;
    @Nullable
    private final String mApkSignedHeaderValue;
    @Nullable
    private ZFileExtension mExtension;

    public SignatureExtension(@Nonnull ManifestGenerationExtension manifestExtension, int minSdkVersion, @Nonnull X509Certificate certificate, @Nonnull PrivateKey privateKey, @Nullable String apkSignedHeaderValue) throws NoSuchAlgorithmException {
        this.mManifestExtension = manifestExtension;
        this.mSignatureFile = new Manifest();
        this.mDirty = false;
        this.mCertificate = certificate;
        this.mPrivateKey = privateKey;
        this.mApkSignedHeaderValue = apkSignedHeaderValue;
        this.mSignatureAlgorithm = SignatureAlgorithm.fromKeyAlgorithm(privateKey.getAlgorithm(), minSdkVersion);
        this.mDigestAlgorithm = DigestAlgorithm.findBest(minSdkVersion, this.mSignatureAlgorithm);
        this.mMessageDigest = MessageDigest.getInstance(this.mDigestAlgorithm.messageDigestName);
    }

    public void register() throws IOException {
        Preconditions.checkState((this.mExtension == null ? 1 : 0) != 0, (Object)"register() already invoked");
        this.mExtension = new ZFileExtension(){

            @Override
            @Nullable
            public IOExceptionRunnable beforeUpdate() {
                return () -> SignatureExtension.this.updateSignatureIfNeeded();
            }

            @Override
            @Nullable
            public IOExceptionRunnable added(@Nonnull StoredEntry entry, @Nullable StoredEntry replaced) {
                if (replaced != null) {
                    Preconditions.checkArgument((boolean)entry.getCentralDirectoryHeader().getName().equals(replaced.getCentralDirectoryHeader().getName()));
                }
                if (SignatureExtension.isIgnoredFile(entry.getCentralDirectoryHeader().getName())) {
                    return null;
                }
                return () -> {
                    if (replaced != null) {
                        SignatureExtension.this.removed(replaced);
                    }
                    SignatureExtension.this.added(entry);
                };
            }

            @Override
            @Nullable
            public IOExceptionRunnable removed(@Nonnull StoredEntry entry) {
                if (SignatureExtension.isIgnoredFile(entry.getCentralDirectoryHeader().getName())) {
                    return null;
                }
                return () -> SignatureExtension.this.removed(entry);
            }
        };
        this.mManifestExtension.zFile().addZFileExtension(this.mExtension);
        this.readSignatureFile();
    }

    private void readSignatureFile() throws IOException {
        boolean needsNewSignature = false;
        StoredEntry signatureEntry = this.mManifestExtension.zFile().get(SIGNATURE_FILE);
        if (signatureEntry != null) {
            byte[] signatureData = signatureEntry.read();
            this.mSignatureFile.read(new ByteArrayInputStream(signatureData));
            Attributes mainAttrs = this.mSignatureFile.getMainAttributes();
            String versionName = mainAttrs.getValue(SIGNATURE_VERSION_NAME);
            String createdBy = mainAttrs.getValue(SIGNATURE_CREATED_BY_NAME);
            String apkSigned = mainAttrs.getValue(SIGNATURE_ANDROID_APK_SIGNED_NAME);
            if (!(SIGNATURE_VERSION_VALUE.equals(versionName) && SIGNATURE_CREATED_BY_VALUE.equals(createdBy) && mainAttrs.getValue(this.mDigestAlgorithm.manifestAttributeName) != null && Objects.equal((Object)this.mApkSignedHeaderValue, (Object)apkSigned))) {
                needsNewSignature = true;
            }
        } else {
            needsNewSignature = true;
        }
        if (needsNewSignature) {
            Attributes mainAttrs = this.mSignatureFile.getMainAttributes();
            mainAttrs.putValue(SIGNATURE_CREATED_BY_NAME, SIGNATURE_CREATED_BY_VALUE);
            mainAttrs.putValue(SIGNATURE_VERSION_NAME, SIGNATURE_VERSION_VALUE);
            if (this.mApkSignedHeaderValue != null) {
                mainAttrs.putValue(SIGNATURE_ANDROID_APK_SIGNED_NAME, this.mApkSignedHeaderValue);
            } else {
                mainAttrs.remove(SIGNATURE_ANDROID_APK_SIGNED_NAME);
            }
            this.mDirty = true;
        }
        Set allEntries = this.mManifestExtension.zFile().entries().stream().filter(se -> !SignatureExtension.isIgnoredFile(se.getCentralDirectoryHeader().getName())).collect(Collectors.toSet());
        HashSet sigEntriesToRemove = Sets.newHashSet(this.mSignatureFile.getEntries().keySet());
        HashSet manEntriesToRemove = Sets.newHashSet(this.mManifestExtension.allEntries().keySet());
        for (StoredEntry se2 : allEntries) {
            this.setDigestForEntry(se2);
            sigEntriesToRemove.remove(se2.getCentralDirectoryHeader().getName());
            manEntriesToRemove.remove(se2.getCentralDirectoryHeader().getName());
        }
        for (String toRemoveInSignature : sigEntriesToRemove) {
            this.mSignatureFile.getEntries().remove(toRemoveInSignature);
            this.mDirty = true;
        }
        for (String toRemoveInManifest : manEntriesToRemove) {
            this.mManifestExtension.removeEntry(toRemoveInManifest);
        }
    }

    private void updateSignatureIfNeeded() throws IOException {
        byte[] manifestData = this.mManifestExtension.getManifestBytes();
        byte[] manifestDataDigest = this.mMessageDigest.digest(manifestData);
        String manifestDataDigestTxt = Base64.getEncoder().encodeToString(manifestDataDigest);
        if (!manifestDataDigestTxt.equals(this.mSignatureFile.getMainAttributes().getValue(this.mDigestAlgorithm.manifestAttributeName))) {
            this.mSignatureFile.getMainAttributes().putValue(this.mDigestAlgorithm.manifestAttributeName, manifestDataDigestTxt);
            this.mDirty = true;
        }
        if (!this.mDirty) {
            return;
        }
        ByteArrayOutputStream signatureBytes = new ByteArrayOutputStream();
        this.mSignatureFile.write(signatureBytes);
        this.mManifestExtension.zFile().add(SIGNATURE_FILE, new ByteArrayInputStream(signatureBytes.toByteArray()));
        String digitalSignatureFile = "META-INF/CERT." + this.mPrivateKey.getAlgorithm();
        try {
            this.mManifestExtension.zFile().add(digitalSignatureFile, new ByteArrayInputStream(this.computePkcs7Signature(signatureBytes.toByteArray())));
        }
        catch (CertificateEncodingException | CMSException | OperatorCreationException e) {
            throw new IOException("Failed to digitally sign signature file.", e);
        }
        this.mDirty = false;
    }

    private void added(@Nonnull StoredEntry entry) throws IOException {
        this.setDigestForEntry(entry);
    }

    private void setDigestForEntry(@Nonnull StoredEntry entry) throws IOException {
        String entryName = entry.getCentralDirectoryHeader().getName();
        byte[] entryDigestArray = this.mMessageDigest.digest(entry.read());
        String entryDigest = Base64.getEncoder().encodeToString(entryDigestArray);
        Attributes signatureAttributes = this.mSignatureFile.getEntries().get(entryName);
        if (signatureAttributes == null) {
            signatureAttributes = new Attributes();
            this.mSignatureFile.getEntries().put(entryName, signatureAttributes);
            this.mDirty = true;
        }
        if (!entryDigest.equals(signatureAttributes.getValue(this.mDigestAlgorithm.entryAttributeName))) {
            signatureAttributes.putValue(this.mDigestAlgorithm.entryAttributeName, entryDigest);
            this.mDirty = true;
        }
        this.mManifestExtension.setAttribute(entryName, this.mDigestAlgorithm.entryAttributeName, entryDigest);
    }

    private void removed(@Nonnull StoredEntry entry) {
        this.mSignatureFile.getEntries().remove(entry.getCentralDirectoryHeader().getName());
        this.mManifestExtension.removeEntry(entry.getCentralDirectoryHeader().getName());
        this.mDirty = true;
    }

    public static boolean isIgnoredFile(@Nonnull String name) {
        boolean inMetaInf;
        String metaInfPfx = "META-INF/";
        boolean bl = inMetaInf = name.startsWith(metaInfPfx) && !name.substring(metaInfPfx.length()).contains("/");
        if (!inMetaInf) {
            return false;
        }
        String nameLc = name.toLowerCase(Locale.US);
        if (IGNORED_FILES_LC.contains(nameLc)) {
            return true;
        }
        for (String pfx : IGNORED_PREFIXES_LC) {
            if (!nameLc.startsWith(pfx)) continue;
            return true;
        }
        for (String sfx : IGNORED_SUFFIXES_LC) {
            if (!nameLc.endsWith(sfx)) continue;
            return true;
        }
        return false;
    }

    private byte[] computePkcs7Signature(@Nonnull byte[] data) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
        ByteArrayOutputStream outputBytes;
        block16: {
            CMSProcessableByteArray cmsData = new CMSProcessableByteArray(data);
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(this.mCertificate);
            JcaCertStore certs = new JcaCertStore(certList);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            String signatureAlgName = this.mSignatureAlgorithm.signatureAlgorithmName(this.mDigestAlgorithm);
            ContentSigner shaSigner = new JcaContentSignerBuilder(signatureAlgName).build(this.mPrivateKey);
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).setDirectSignature(true).build(shaSigner, this.mCertificate));
            gen.addCertificates((Store)certs);
            CMSSignedData sigData = gen.generate((CMSTypedData)cmsData, false);
            outputBytes = new ByteArrayOutputStream();
            DEROutputStream dos = null;
            try (ASN1InputStream asn1 = new ASN1InputStream(sigData.getEncoded());){
                dos = new DEROutputStream((OutputStream)outputBytes);
                dos.writeObject((ASN1Encodable)asn1.readObject());
                DEROutputStream toClose = dos;
                dos = null;
                toClose.close();
            }
            catch (IOException e) {
                if (dos == null) break block16;
                try {
                    dos.close();
                }
                catch (IOException ee) {
                    e.addSuppressed(ee);
                }
            }
        }
        return outputBytes.toByteArray();
    }
}

