/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.sign;

import com.android.apkzlib.sign.SignatureAlgorithm;
import javax.annotation.Nonnull;

public enum DigestAlgorithm {
    SHA1("SHA1", "SHA-1"),
    SHA256("SHA-256", "SHA-256");

    public static final int API_SHA_256_RSA = 18;
    public static final int API_SHA_256_ALL_ALGORITHMS = 21;
    @Nonnull
    public final String messageDigestName;
    @Nonnull
    public final String manifestAttributeName;
    @Nonnull
    public final String entryAttributeName;

    private DigestAlgorithm(String attributeName, String messageDigestName) {
        this.messageDigestName = messageDigestName;
        this.entryAttributeName = attributeName + "-Digest";
        this.manifestAttributeName = attributeName + "-Digest-Manifest";
    }

    @Nonnull
    public static DigestAlgorithm findBest(int minSdk, @Nonnull SignatureAlgorithm signatureAlgorithm) {
        if (signatureAlgorithm == SignatureAlgorithm.RSA) {
            return minSdk >= 18 ? SHA256 : SHA1;
        }
        return minSdk >= 21 ? SHA256 : SHA1;
    }
}

