/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.DefaultRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.Request;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.SdkClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.http.HttpMethodName;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.internal.SdkInternalList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.Marshaller;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.MessageSystemAttributeValue;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import java.nio.ByteBuffer;
import java.util.Map;

public class SendMessageBatchRequestMarshaller
implements Marshaller<Request<SendMessageBatchRequest>, SendMessageBatchRequest> {
    @Override
    public Request<SendMessageBatchRequest> marshall(SendMessageBatchRequest sendMessageBatchRequest) {
        if (sendMessageBatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendMessageBatchRequest> request = new DefaultRequest<SendMessageBatchRequest>(sendMessageBatchRequest, "AmazonSQS");
        request.addParameter("Action", "SendMessageBatch");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendMessageBatchRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(sendMessageBatchRequest.getQueueUrl()));
        }
        if (!sendMessageBatchRequest.getEntries().isEmpty() || !((SdkInternalList)sendMessageBatchRequest.getEntries()).isAutoConstruct()) {
            SdkInternalList entriesList = (SdkInternalList)sendMessageBatchRequest.getEntries();
            int entriesListIndex = 1;
            for (SendMessageBatchRequestEntry entriesListValue : entriesList) {
                if (entriesListValue.getId() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".Id", StringUtils.fromString(entriesListValue.getId()));
                }
                if (entriesListValue.getMessageBody() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageBody", StringUtils.fromString(entriesListValue.getMessageBody()));
                }
                if (entriesListValue.getDelaySeconds() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".DelaySeconds", StringUtils.fromInteger(entriesListValue.getDelaySeconds()));
                }
                Map<String, MessageAttributeValue> messageAttributes = entriesListValue.getMessageAttributes();
                int messageAttributesListIndex = 1;
                for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
                    if (entry.getKey() != null) {
                        request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Name", StringUtils.fromString(entry.getKey()));
                    }
                    if (entry.getValue() != null) {
                        if (entry.getValue().getStringValue() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.StringValue", StringUtils.fromString(entry.getValue().getStringValue()));
                        }
                        if (entry.getValue().getBinaryValue() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.BinaryValue", StringUtils.fromByteBuffer(entry.getValue().getBinaryValue()));
                        }
                        if (!entry.getValue().getStringListValues().isEmpty() || !((SdkInternalList)entry.getValue().getStringListValues()).isAutoConstruct()) {
                            SdkInternalList stringListValuesList = (SdkInternalList)entry.getValue().getStringListValues();
                            int stringListValuesListIndex = 1;
                            for (String stringListValuesListValue : stringListValuesList) {
                                if (stringListValuesListValue != null) {
                                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue." + stringListValuesListIndex, StringUtils.fromString(stringListValuesListValue));
                                }
                                ++stringListValuesListIndex;
                            }
                        }
                        if (!entry.getValue().getBinaryListValues().isEmpty() || !((SdkInternalList)entry.getValue().getBinaryListValues()).isAutoConstruct()) {
                            SdkInternalList binaryListValuesList = (SdkInternalList)entry.getValue().getBinaryListValues();
                            int binaryListValuesListIndex = 1;
                            for (ByteBuffer binaryListValuesListValue : binaryListValuesList) {
                                if (binaryListValuesListValue != null) {
                                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue." + binaryListValuesListIndex, StringUtils.fromByteBuffer(binaryListValuesListValue));
                                }
                                ++binaryListValuesListIndex;
                            }
                        }
                        if (entry.getValue().getDataType() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.DataType", StringUtils.fromString(entry.getValue().getDataType()));
                        }
                    }
                    ++messageAttributesListIndex;
                }
                Map<String, MessageSystemAttributeValue> messageSystemAttributes = entriesListValue.getMessageSystemAttributes();
                int messageSystemAttributesListIndex = 1;
                for (Map.Entry<String, MessageSystemAttributeValue> entry : messageSystemAttributes.entrySet()) {
                    if (entry.getKey() != null) {
                        request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageSystemAttribute." + messageSystemAttributesListIndex + ".Name", StringUtils.fromString(entry.getKey()));
                    }
                    if (entry.getValue() != null) {
                        if (entry.getValue().getStringValue() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageSystemAttribute." + messageSystemAttributesListIndex + ".Value.StringValue", StringUtils.fromString(entry.getValue().getStringValue()));
                        }
                        if (entry.getValue().getBinaryValue() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageSystemAttribute." + messageSystemAttributesListIndex + ".Value.BinaryValue", StringUtils.fromByteBuffer(entry.getValue().getBinaryValue()));
                        }
                        if (!entry.getValue().getStringListValues().isEmpty() || !((SdkInternalList)entry.getValue().getStringListValues()).isAutoConstruct()) {
                            SdkInternalList stringListValuesList = (SdkInternalList)entry.getValue().getStringListValues();
                            int stringListValuesListIndex = 1;
                            for (String stringListValuesListValue : stringListValuesList) {
                                if (stringListValuesListValue != null) {
                                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageSystemAttribute." + messageSystemAttributesListIndex + ".Value.StringListValue." + stringListValuesListIndex, StringUtils.fromString(stringListValuesListValue));
                                }
                                ++stringListValuesListIndex;
                            }
                        }
                        if (!entry.getValue().getBinaryListValues().isEmpty() || !((SdkInternalList)entry.getValue().getBinaryListValues()).isAutoConstruct()) {
                            SdkInternalList binaryListValuesList = (SdkInternalList)entry.getValue().getBinaryListValues();
                            int binaryListValuesListIndex = 1;
                            for (ByteBuffer binaryListValuesListValue : binaryListValuesList) {
                                if (binaryListValuesListValue != null) {
                                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageSystemAttribute." + messageSystemAttributesListIndex + ".Value.BinaryListValue." + binaryListValuesListIndex, StringUtils.fromByteBuffer(binaryListValuesListValue));
                                }
                                ++binaryListValuesListIndex;
                            }
                        }
                        if (entry.getValue().getDataType() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageSystemAttribute." + messageSystemAttributesListIndex + ".Value.DataType", StringUtils.fromString(entry.getValue().getDataType()));
                        }
                    }
                    ++messageSystemAttributesListIndex;
                }
                if (entriesListValue.getMessageDeduplicationId() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageDeduplicationId", StringUtils.fromString(entriesListValue.getMessageDeduplicationId()));
                }
                if (entriesListValue.getMessageGroupId() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageGroupId", StringUtils.fromString(entriesListValue.getMessageGroupId()));
                }
                ++entriesListIndex;
            }
        }
        return request;
    }
}

