/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonWebServiceRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class GetQueueAttributesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String queueUrl;
    private SdkInternalList<String> attributeNames;

    public GetQueueAttributesRequest() {
    }

    public GetQueueAttributesRequest(String queueUrl) {
        this.setQueueUrl(queueUrl);
    }

    public GetQueueAttributesRequest(String queueUrl, List<String> attributeNames) {
        this.setQueueUrl(queueUrl);
        this.setAttributeNames(attributeNames);
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public GetQueueAttributesRequest withQueueUrl(String queueUrl) {
        this.setQueueUrl(queueUrl);
        return this;
    }

    public List<String> getAttributeNames() {
        if (this.attributeNames == null) {
            this.attributeNames = new SdkInternalList();
        }
        return this.attributeNames;
    }

    public void setAttributeNames(Collection<String> attributeNames) {
        if (attributeNames == null) {
            this.attributeNames = null;
            return;
        }
        this.attributeNames = new SdkInternalList<String>(attributeNames);
    }

    public GetQueueAttributesRequest withAttributeNames(String ... attributeNames) {
        if (this.attributeNames == null) {
            this.setAttributeNames(new SdkInternalList<String>(attributeNames.length));
        }
        for (String ele : attributeNames) {
            this.attributeNames.add(ele);
        }
        return this;
    }

    public GetQueueAttributesRequest withAttributeNames(Collection<String> attributeNames) {
        this.setAttributeNames(attributeNames);
        return this;
    }

    public GetQueueAttributesRequest withAttributeNames(QueueAttributeName ... attributeNames) {
        SdkInternalList<String> attributeNamesCopy = new SdkInternalList<String>(attributeNames.length);
        for (QueueAttributeName value : attributeNames) {
            attributeNamesCopy.add(value.toString());
        }
        if (this.getAttributeNames() == null) {
            this.setAttributeNames(attributeNamesCopy);
        } else {
            this.getAttributeNames().addAll(attributeNamesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: ").append(this.getQueueUrl()).append(",");
        }
        if (this.getAttributeNames() != null) {
            sb.append("AttributeNames: ").append(this.getAttributeNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueAttributesRequest)) {
            return false;
        }
        GetQueueAttributesRequest other = (GetQueueAttributesRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getAttributeNames() == null ^ this.getAttributeNames() == null) {
            return false;
        }
        return other.getAttributeNames() == null || other.getAttributeNames().equals(this.getAttributeNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeNames() == null ? 0 : this.getAttributeNames().hashCode());
        return hashCode;
    }

    @Override
    public GetQueueAttributesRequest clone() {
        return (GetQueueAttributesRequest)super.clone();
    }
}

