/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.buffered;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.handlers.AsyncHandler;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.logging.Log;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.buffered.QueueBufferCallback;
import com.amazonaws.services.sqs.buffered.QueueBufferConfig;
import com.amazonaws.services.sqs.buffered.QueueBufferFuture;
import com.amazonaws.services.sqs.buffered.ReceiveQueueBuffer;
import com.amazonaws.services.sqs.buffered.SendQueueBuffer;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResultEntry;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class QueueBuffer {
    private static final Log log = LogFactory.getLog(QueueBuffer.class);
    private static final AsyncHandler<DeleteMessageRequest, DeleteMessageResult> DEFAULT_BACKGROUND_DELETE_ASYNC_HANDLER = new AsyncHandler<DeleteMessageRequest, DeleteMessageResult>(){

        @Override
        public void onSuccess(DeleteMessageRequest request, DeleteMessageResult deleteMessageResult) {
        }

        @Override
        public void onError(Exception exception) {
            log.warn("Failed to delete message in background (config.isDeleteInBackground() is true) - message will likely be redelivered", exception);
        }
    };
    private final SendQueueBuffer sendBuffer;
    private final ReceiveQueueBuffer receiveBuffer;
    private final AmazonSQSAsync realSqs;
    QueueBufferConfig config;
    private final AsyncHandler<DeleteMessageRequest, DeleteMessageResult> backgroundDeleteAsyncHandler;
    static ExecutorService executor = Executors.newCachedThreadPool(new DaemonThreadFactory());

    QueueBuffer(QueueBufferConfig paramConfig, String url, AmazonSQSAsync sqs) {
        this(paramConfig, url, sqs, DEFAULT_BACKGROUND_DELETE_ASYNC_HANDLER);
    }

    QueueBuffer(QueueBufferConfig paramConfig, String url, AmazonSQSAsync sqs, AsyncHandler<DeleteMessageRequest, DeleteMessageResult> backgroundDeleteAsyncHandler) {
        this.realSqs = sqs;
        this.config = paramConfig;
        this.sendBuffer = new SendQueueBuffer(sqs, executor, paramConfig, url);
        this.receiveBuffer = new ReceiveQueueBuffer(sqs, executor, paramConfig, url);
        this.backgroundDeleteAsyncHandler = backgroundDeleteAsyncHandler;
    }

    public Future<SendMessageResult> sendMessage(SendMessageRequest request, AsyncHandler<SendMessageRequest, SendMessageResult> handler) {
        QueueBufferCallback<SendMessageRequest, SendMessageResult> callback = null;
        if (handler != null) {
            callback = new QueueBufferCallback<SendMessageRequest, SendMessageResult>(handler, request);
        }
        QueueBufferFuture<SendMessageRequest, SendMessageResult> future = this.sendBuffer.sendMessage(request, callback);
        future.setBuffer(this);
        return future;
    }

    public SendMessageResult sendMessageSync(SendMessageRequest request) {
        Future<SendMessageResult> future = this.sendMessage(request, null);
        return this.waitForFuture(future);
    }

    public Future<DeleteMessageResult> deleteMessage(DeleteMessageRequest request, AsyncHandler<DeleteMessageRequest, DeleteMessageResult> handler) {
        QueueBufferCallback<DeleteMessageRequest, DeleteMessageResult> callback = null;
        if (handler != null) {
            callback = new QueueBufferCallback<DeleteMessageRequest, DeleteMessageResult>(handler, request);
        }
        QueueBufferFuture<DeleteMessageRequest, DeleteMessageResult> future = this.sendBuffer.deleteMessage(request, callback);
        future.setBuffer(this);
        return future;
    }

    public DeleteMessageResult deleteMessageSync(DeleteMessageRequest request) {
        if (this.config.isDeleteInBackground()) {
            this.deleteMessage(request, this.backgroundDeleteAsyncHandler);
            return new DeleteMessageResult();
        }
        Future<DeleteMessageResult> future = this.deleteMessage(request, null);
        return this.waitForFuture(future);
    }

    public DeleteMessageBatchResult deleteMessageBatchSync(DeleteMessageBatchRequest request) {
        if (this.config.isDeleteInBackground()) {
            String queueUrl = request.getQueueUrl();
            List<DeleteMessageBatchRequestEntry> requestEntries = request.getEntries();
            ArrayList<DeleteMessageBatchResultEntry> resultEntries = new ArrayList<DeleteMessageBatchResultEntry>(requestEntries.size());
            for (DeleteMessageBatchRequestEntry entry : requestEntries) {
                this.deleteMessage(new DeleteMessageRequest().withQueueUrl(queueUrl).withReceiptHandle(entry.getReceiptHandle()), this.backgroundDeleteAsyncHandler);
                resultEntries.add(new DeleteMessageBatchResultEntry().withId(entry.getId()));
            }
            return new DeleteMessageBatchResult().withSuccessful(resultEntries);
        }
        return this.realSqs.deleteMessageBatch(request);
    }

    public Future<ChangeMessageVisibilityResult> changeMessageVisibility(ChangeMessageVisibilityRequest request, AsyncHandler<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> handler) {
        QueueBufferCallback<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> callback = null;
        if (handler != null) {
            callback = new QueueBufferCallback<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult>(handler, request);
        }
        QueueBufferFuture<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> future = this.sendBuffer.changeMessageVisibility(request, callback);
        future.setBuffer(this);
        return future;
    }

    public ChangeMessageVisibilityResult changeMessageVisibilitySync(ChangeMessageVisibilityRequest request) {
        QueueBufferFuture<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> future = this.sendBuffer.changeMessageVisibility(request, null);
        return (ChangeMessageVisibilityResult)this.waitForFuture(future);
    }

    public Future<ReceiveMessageResult> receiveMessage(ReceiveMessageRequest rq, AsyncHandler<ReceiveMessageRequest, ReceiveMessageResult> handler) {
        if (this.canBeRetrievedFromQueueBuffer(rq)) {
            QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResult> callback = null;
            if (handler != null) {
                callback = new QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResult>(handler, rq);
            }
            QueueBufferFuture<ReceiveMessageRequest, ReceiveMessageResult> future = this.receiveBuffer.receiveMessageAsync(rq, callback);
            future.setBuffer(this);
            return future;
        }
        if (handler != null) {
            return this.realSqs.receiveMessageAsync(rq, handler);
        }
        return this.realSqs.receiveMessageAsync(rq);
    }

    public ReceiveMessageResult receiveMessageSync(ReceiveMessageRequest rq) {
        Future<ReceiveMessageResult> future = this.receiveMessage(rq, null);
        return this.waitForFuture(future);
    }

    public void shutdown() {
        if (this.config.isFlushOnShutdown()) {
            this.flush();
        }
        this.receiveBuffer.shutdown();
    }

    void flush() {
        this.sendBuffer.flush();
    }

    private boolean canBeRetrievedFromQueueBuffer(ReceiveMessageRequest rq) {
        return this.requestedAttributesAreCompatible(rq) && this.requestedMessageAttributesAreCompatible(rq) && this.isBufferingEnabled() && rq.getVisibilityTimeout() == null;
    }

    private boolean requestedAttributesAreCompatible(ReceiveMessageRequest rq) {
        return rq.getAttributeNames().equals(this.config.getReceiveAttributeNames());
    }

    private boolean requestedMessageAttributesAreCompatible(ReceiveMessageRequest rq) {
        return rq.getMessageAttributeNames().equals(this.config.getReceiveMessageAttributeNames());
    }

    private boolean isBufferingEnabled() {
        return this.config.getMaxInflightReceiveBatches() > 0 && this.config.getMaxDoneReceiveBatches() > 0;
    }

    private <ResultType> ResultType waitForFuture(Future<ResultType> future) {
        ResultType toReturn = null;
        try {
            toReturn = future.get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            AmazonClientException ce = new AmazonClientException("Thread interrupted while waiting for execution result");
            ce.initCause(ie);
            throw ce;
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof AmazonClientException) {
                throw (AmazonClientException)cause;
            }
            AmazonClientException ce = new AmazonClientException("Caught an exception while waiting for request to complete...");
            ce.initCause(ee);
            throw ce;
        }
        return toReturn;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        static AtomicInteger threadCount = new AtomicInteger(0);

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            int threadNumber = threadCount.addAndGet(1);
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("SQSQueueBufferWorkerThread-" + threadNumber);
            return thread;
        }
    }
}

