/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util.io;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.annotation.NotThreadSafe;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.io.input.ClosedInputStream;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.io.input.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;

@NotThreadSafe
public final class RestartableInputStream
extends ProxyInputStream {
    private final InputStream originalIn;
    private boolean isReleased;
    private boolean isAtStart = true;
    private boolean isMarkAtStart = true;

    public RestartableInputStream(InputStream in) {
        this(in, -1);
    }

    public RestartableInputStream(InputStream in, int readLimitForMark) {
        super(in);
        this.originalIn = in;
        if (this.originalIn.markSupported()) {
            Preconditions.checkArgument(readLimitForMark > 0, "Must specify read limit for mark supported input streams");
            this.originalIn.mark(readLimitForMark);
        }
    }

    public void restart() throws IOException {
        this.checkIfNotReleased();
        boolean wasCloseCalled = this.wasCloseCalled();
        try {
            if (wasCloseCalled) {
                this.in = this.originalIn;
            }
            if (this.isAtStart) {
                return;
            }
            if (!this.markSupported()) {
                throw new IOException("Cannot restart the stream as mark-and-reset was not supported");
            }
            if (!this.isMarkAtStart) {
                throw new IOException("Cannot restart the stream as caller marked the stream passed the initial starting position.");
            }
            this.reset();
        }
        catch (Exception e) {
            if (wasCloseCalled) {
                this.close();
            }
            throw e;
        }
    }

    public void release() throws IOException {
        this.isReleased = true;
        this.originalIn.close();
    }

    @Override
    protected void beforeRead(int bytesToRead) throws IOException {
        this.checkIfOpen();
    }

    @Override
    protected void afterRead(int bytesRead) throws IOException {
        this.advance(bytesRead);
    }

    @Override
    public long skip(long ln) throws IOException {
        this.checkIfOpen();
        long bytesSkipped = super.skip(ln);
        this.advance(bytesSkipped);
        return bytesSkipped;
    }

    @Override
    public int available() throws IOException {
        this.checkIfOpen();
        return super.available();
    }

    @Override
    public void close() {
        this.in = ClosedInputStream.CLOSED_INPUT_STREAM;
    }

    @Override
    public synchronized void mark(int readLimit) {
        if (this.wasCloseCalled()) {
            return;
        }
        super.mark(readLimit);
        this.isMarkAtStart = this.isAtStart;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkIfOpen();
        super.reset();
        this.isAtStart = this.isMarkAtStart;
    }

    private void advance(long amount) {
        if (amount > 0L) {
            this.isAtStart = false;
        }
    }

    private boolean wasCloseCalled() {
        return this.in instanceof ClosedInputStream;
    }

    private void checkIfOpen() throws IOException {
        this.checkIfNotReleased();
        if (this.wasCloseCalled()) {
            throw new IOException("Stream must be open or restarted");
        }
    }

    private void checkIfNotReleased() throws IOException {
        if (this.isReleased) {
            throw new IOException("Stream was released");
        }
    }
}

