/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.util.EC2MetadataUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.amazon.ws.emr.hadoop.fs.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.amazon.ws.emr.hadoop.fs.shaded.com.fasterxml.jackson.core.JsonParseException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.amazon.ws.emr.hadoop.fs.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.io.FileUtils;
import com.amazon.ws.emr.hadoop.fs.util.AwsClientConfiguration;
import java.io.File;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserData {
    private static final Logger logger = LoggerFactory.getLogger(UserData.class);
    private static final String USER_DATA_LOCAL_FILE_PATH = "/var/aws/emr/userData.json";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static UserData defaultUserData;
    private final AwsClientConfiguration instanceAwsClientConfiguration;

    UserData(String userDataFilePath) {
        Optional<UserData> userData = this.getUserData(userDataFilePath);
        this.instanceAwsClientConfiguration = userData.isPresent() ? userData.get().instanceAwsClientConfiguration : null;
    }

    @JsonCreator
    UserData(@JsonProperty(value="instanceAwsClientConfiguration") AwsClientConfiguration instanceAwsClientConfiguration) {
        this.instanceAwsClientConfiguration = instanceAwsClientConfiguration;
    }

    static UserData ofDefaultResourceLocations() {
        if (defaultUserData == null) {
            defaultUserData = new UserData(USER_DATA_LOCAL_FILE_PATH);
        }
        return defaultUserData;
    }

    private Optional<UserData> getUserData(String userDataFilePath) {
        String userDataJson = "";
        try {
            File userDataFile = new File(userDataFilePath);
            userDataJson = userDataFile.exists() ? FileUtils.readFileToString(userDataFile) : EC2MetadataUtils.getUserData();
            return Optional.ofNullable(mapper.readValue(userDataJson, UserData.class));
        }
        catch (JsonParseException | JsonMappingException ex) {
            logger.error("Error parsing user data json: " + userDataJson, (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Error encountered while try to get user data", (Throwable)ex);
        }
        return Optional.empty();
    }

    Optional<AwsClientConfiguration> getInstanceAwsClientConfiguration() {
        return Optional.ofNullable(this.instanceAwsClientConfiguration);
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

