/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import java.net.URI;
import java.net.URISyntaxException;
import lombok.NonNull;

public final class Uris {
    public static URI withOriginOnly(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        String path = uri.getScheme() != null && uri.getAuthority() == null ? "/" : null;
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("URI composed is expected to always be syntactically valid", e);
        }
    }

    private Uris() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

