/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.util.S3AccessPointUtils;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3UriUtils {
    private static final Logger logger = LoggerFactory.getLogger(S3UriUtils.class);

    public static String pathToBucket(Path path) {
        return S3UriUtils.uriToBucket(path.toUri());
    }

    public static String pathToKey(Path path) {
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        Preconditions.checkState(path.isAbsolute(), "Invalid path - must be absolute: " + path);
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        String ret = path.toUri().getPath().substring(1);
        if (ret.endsWith("/") && ret.indexOf("/") != ret.length() - 1) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static String uriToBucket(@NotNull URI uri) {
        if ((uri = S3AccessPointUtils.convertS3apARNColonFormatIfApply(uri)).toString().matches("^s3://arn:aws:s3:\\S*:[0-9]{1,12}:accesspoint:.*$")) {
            return S3AccessPointUtils.getBucketnameFromS3apColonFormat(uri);
        }
        return uri.getAuthority();
    }

    public static Path getPathForS3Object(String bucketName, String key) {
        return new Path("s3://" + bucketName + "/" + key);
    }

    public static Path keyToPath(String bucketName, String key) {
        return new Path("/" + bucketName + "/" + key);
    }

    public static Path keyToPath(String key) {
        return new Path("/" + key);
    }

    public static Path makeAbsolute(Path workingDirectory, Path path) {
        return path.isAbsolute() ? path : new Path(workingDirectory, path);
    }

    private S3UriUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

