/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Splitter;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public final class S3Keys {
    public static Optional<String> getParent(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        List<String> splits = Splitter.on("/").omitEmptyStrings().splitToList(key);
        if (splits.isEmpty()) {
            return Optional.empty();
        }
        List<String> parentSplits = splits.subList(0, splits.size() - 1);
        return Optional.of(Joiner.on("/").join(parentSplits));
    }

    private S3Keys() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

