/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.Path;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3AccessPointUtils {
    private static final Logger logger = LoggerFactory.getLogger(S3AccessPointUtils.class);
    public static final String s3apARNColonFormat = "^s3://arn:aws:s3:\\S*:[0-9]{1,12}:accesspoint:.*$";
    public static final String s3apARNSlashFormat = "^s3://arn:aws:s3:\\S*:[0-9]{1,12}:accesspoint/.*$";
    private static final String ACCESSPOINT_WITH_COLON = "accesspoint:";
    private static final String ACCESSPOINT_WITH_SLASH = "accesspoint/";

    public static Path convertS3apARNColonFormatIfApply(@Nullable Path path) {
        logger.debug("Try to convert Path {} to S3 access point format", (Object)path);
        if (path == null) {
            return null;
        }
        String pathString = path.toString();
        if (pathString.matches(s3apARNSlashFormat)) {
            return new Path(S3AccessPointUtils.convertS3apARNFromSlashFormatToColonFormat(pathString));
        }
        return path;
    }

    public static URI convertS3apARNColonFormatIfApply(@Nullable URI uri) {
        logger.debug("Try to convert URI {} to S3 access point format", (Object)uri);
        if (uri == null) {
            return null;
        }
        String uriString = uri.toString();
        if (uriString.matches(s3apARNSlashFormat)) {
            try {
                return new URI(S3AccessPointUtils.convertS3apARNFromSlashFormatToColonFormat(uriString));
            }
            catch (URISyntaxException e) {
                logger.error("Cannot convert s3ap arn {}", (Object)uri);
            }
        }
        return uri;
    }

    public static Path[] convertS3apARNColonFormatIfApply(@Nullable Path[] srcs) {
        if (srcs != null) {
            return (Path[])Arrays.stream(srcs).map(S3AccessPointUtils::convertS3apARNColonFormatIfApply).toArray(Path[]::new);
        }
        return null;
    }

    private static String convertS3apARNFromSlashFormatToColonFormat(String path) {
        return path.replaceFirst(ACCESSPOINT_WITH_SLASH, ACCESSPOINT_WITH_COLON);
    }

    public static boolean isS3AccessPointArn(String bucket) {
        return bucket.contains(ACCESSPOINT_WITH_SLASH) || bucket.contains(ACCESSPOINT_WITH_COLON);
    }

    @NotNull
    public static String getBucketnameFromS3apColonFormat(@NotNull URI uri) {
        return uri.getAuthority().replaceFirst(ACCESSPOINT_WITH_COLON, ACCESSPOINT_WITH_SLASH);
    }

    private S3AccessPointUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

