/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.RemoteIterator;

public final class RemoteIterators {
    public static <T> RemoteIterator<T> singleton(final T value) {
        return new RemoteIterator<T>(){
            boolean done;

            public boolean hasNext() {
                return !this.done;
            }

            public T next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return value;
            }
        };
    }

    public static void exhaust(RemoteIterator<?> iterator) throws IOException {
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private RemoteIterators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

