/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Optional;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlatformInfo {
    private static final Logger logger = LoggerFactory.getLogger(PlatformInfo.class);
    private static final String EXTRA_INSTANCE_DATA_JSON_FILE = "/var/lib/instance-controller/extraInstanceData.json";
    private static final String EMR_JOB_FLOW_JSON_FILE = "/var/lib/info/job-flow.json";
    private static final String CONFIG_ENDPOINT = "http://localhost:8321/configuration";
    private static final String CLUSTER_ID_KEY = "clusterId";
    private static final String JOB_FLOW_ID_KEY = "jobFlowId";
    private final String extraInstanceDataJson;
    private final String emrJobFlowJson;
    private final String configEndpoint;

    public static PlatformInfo forDefaultResourceLocations() {
        return new PlatformInfo(EXTRA_INSTANCE_DATA_JSON_FILE, EMR_JOB_FLOW_JSON_FILE, CONFIG_ENDPOINT);
    }

    public static Builder builder() {
        return new Builder();
    }

    private String getClusterIdFromConfigurationEndpoint() throws IOException {
        return (String)new ObjectMapper().readValue(new URL(this.configEndpoint), Map.class).get(CLUSTER_ID_KEY);
    }

    private String getClusterIdFromEmrJobFlowJson() throws IOException {
        return (String)new ObjectMapper().readValue(new File(this.emrJobFlowJson), Map.class).get(JOB_FLOW_ID_KEY);
    }

    private String getClusterIdFromExtraInstanceDataJson() throws IOException {
        return (String)new ObjectMapper().readValue(new File(this.extraInstanceDataJson), Map.class).get(JOB_FLOW_ID_KEY);
    }

    public String getJobFlowId() {
        String clusterId = null;
        try {
            clusterId = this.getClusterIdFromConfigurationEndpoint();
        }
        catch (IOException e) {
            logger.info("Unable to read clusterId from {}, trying extra instance data file: {}", (Object)this.configEndpoint, (Object)this.extraInstanceDataJson);
        }
        if (Strings.isNullOrEmpty(clusterId)) {
            try {
                clusterId = this.getClusterIdFromExtraInstanceDataJson();
            }
            catch (IOException e) {
                logger.info("Unable to read clusterId from {}, trying EMR job-flow data file: {}", (Object)this.extraInstanceDataJson, (Object)this.emrJobFlowJson);
            }
        }
        if (Strings.isNullOrEmpty(clusterId)) {
            try {
                clusterId = this.getClusterIdFromEmrJobFlowJson();
            }
            catch (IOException e) {
                logger.info("Unable to read clusterId from {}, out of places to look", (Object)this.emrJobFlowJson);
            }
        }
        return clusterId;
    }

    public PlatformInfo(String extraInstanceDataJson, String emrJobFlowJson, String configEndpoint) {
        this.extraInstanceDataJson = extraInstanceDataJson;
        this.emrJobFlowJson = emrJobFlowJson;
        this.configEndpoint = configEndpoint;
    }

    public static class Builder {
        private String extraInstanceDataJsonFile;
        private String emrJobFlowJsonFile;
        private String configEndpoint;

        public Builder withExtraInstanceDataJsonFile(String extraInstanceDataJson) {
            this.extraInstanceDataJsonFile = extraInstanceDataJson;
            return this;
        }

        public Builder withEmrJobFlowJsonFile(String emrJobFlowJson) {
            this.emrJobFlowJsonFile = emrJobFlowJson;
            return this;
        }

        public Builder withConfigurationEndpoint(String configEndpoint) {
            this.configEndpoint = configEndpoint;
            return this;
        }

        public PlatformInfo build() {
            return new PlatformInfo(Optional.fromNullable(this.extraInstanceDataJsonFile).or(PlatformInfo.EXTRA_INSTANCE_DATA_JSON_FILE), Optional.fromNullable(this.emrJobFlowJsonFile).or(PlatformInfo.EMR_JOB_FLOW_JSON_FILE), Optional.fromNullable(this.configEndpoint).or(PlatformInfo.CONFIG_ENDPOINT));
        }
    }
}

